function [view,OK] = editROIFields(view,n)
%  [view,OK] = editROIFields(view,n)
% Function to edit the name and color of an ROI
% ARW 040104 : Added uisetcolor option, ability to use [R G B] color format

colorList = {'yellow','magenta','cyan','red','green','blue','white','kblack','user'};

colorChar = char(colorList)';
colorChar = colorChar(1,:);

if ~exist('n','var'), n = view.selectedROI; end

ROI = view.ROIs(n);
if (ischar(ROI.color))
    
    colorNum = findstr(ROI.color,colorChar);
    switch lower(ROI.color)
        case 'yellow',  colorRGB=[1 1 0];
        case 'magenta', colorRGB=[1 0 1];
        case 'cyan',    colorRGB=[0 1 1];
        case 'red',     colorRGB=[1 0 0];
        case 'green',   colorRGB=[0 1 0];
        case 'blue',    colorRGB=[0 0 1];
        case 'white',   colorRGB=[1 1 1];
        case 'k',       colorRGB=[0 0 0];
        otherwise
            colorRGB=[0 0 0];
    end
else
    colorNum=8; colorRGB=ROI.color;
end

dlg(1).string = 'ROI name:';
dlg(1).fieldName = 'name';
dlg(1).style = 'edit';
dlg(1).value = ROI.name;

dlg(2).string = 'Color:';
dlg(2).fieldName = 'color';
dlg(2).list = colorList;
dlg(2).choice = colorNum;
dlg(2).style = 'popupmenu';
if ischar(ROI.color)
    dlg(2).value = colorList{colorNum};
else
    dlg(2).value = 'user';
end

dlg(3).string = 'Save this ROI when done';
dlg(3).fieldName = 'save';
dlg(3).style = 'checkbox';
dlg(3).value = 1;

resp = generalDialog(dlg,'Edit ROI Fields');

% If user selects 'OK', change the parameters.  Otherwise the
% user isn't happy with these settings so bail out.
if ~isempty(resp)
    ROI = mergeStructures(ROI, resp); 
    if (strcmp(ROI.color,'user'))
        ROI.color = uisetcolor(colorRGB);
    else
        ROI.color = ROI.color(1);
    end
    
    % Save, but only if this ROI is named (no 'ROI*' names)
    if resp.save==1 & ~(length(ROI.name)>3 & strncmp(ROI.name,'ROI',3))
        saveROI(view, ROI);
    end

    ROI = rmfield(ROI, 'save');
    
    for f = fieldnames(ROI)'
        view.ROIs(n).(f{1}) = ROI.(f{1});
    end
    
    OK = 1;
else 
    OK = 0;
end


return

