function view = deleteROI(view,n)
%
% view = deleteROI(view,n)
%
% Deletes the nth ROI in view.ROIs.  If that happens to be the
% selected ROI, selects the first nonempty ROI in view.ROIs.
%
% djh, 1/26/98
% gmb, 4/25/98 added ROI popup menu code

if ieNotDefined('n'), n = viewGet(view,'currentroi'); end

% I don't understand why we would choose n to be 0.
if n==0
  myErrorDlg('No ROIs to delete')
  return;
end

% Here is the deletion
view.ROIs(n)=[];

% Here is the adjustment
if (view.selectedROI == n)
    view.selectedROI = 0;
    if length(view.ROIs)>0
        sel = max(1,n-1);
        view = selectROI(view,sel);
    end
elseif (view.selectedROI > n)
    view.selectedROI = view.selectedROI-1;
end

% Set the ROI popup menu
setROIPopup(view);

return;