function view = clearROIslice(view)
%
% view = clearROIslice(view)
%
% Zeros out selpts in current slice of selected ROI.
%
% djh, 1/11/98

% error if no current ROI
if view.selectedROI == 0
  myErrorDlg('No current ROI');
end

coords = getCurROIcoords(view);

% Save prevSelpts for undo
view.prevCoords = coords;

% Get slice orientation
if strcmp('Volume',view.viewType) | strcmp('Gray',view.viewType)
  ori = getCurSliceOri(view);
else
  ori = 3;
end

% Get indices corresponding to current slice
curSlice = getCurSlice(view);
indices = find(coords(ori,:)~=curSlice);

% set ROI coords according to those indices
selectedROI = view.selectedROI;
view.ROIs(selectedROI).coords = coords(:,indices);
