function view = addROIgrow(view,sgn);
% view = addROIgrow(view,[sgn]);
%
% Grows a ROI region in 3D (ie not just in current slice) using a
% three-dimensional six-connected neighborhood.
%
% If sgn~=0, adds user-specified rectangle to selected ROI in
% current slice. If sgn==0, removes the rectangle from the ROI.
%
% 27/06/2005 SOD

if ieNotDefined('sgn'), sgn = 1; end

% error if no current ROI
if view.selectedROI==0, myErrorDlg('No current ROI'); return; end

% Get current ROI coords
curCoords = getCurROIcoords(view);

% Save prevSelpts for undo
view.prevCoords = curCoords;

% Get curSlice
curSlice = getCurSlice(view);

% Get starting point from user.
% (rgn is short for region)
rgn = round(ginput(1));

% Note: ginput hands them back in x, y order (1st col is x and
% 2nd col is y).  But we use them in the opposite order (y then
% x), so flip 'em.
rgn = fliplr(rgn);

% Check if outside image
dims = size(get(findobj('Parent', gca, 'Type', 'Image'), 'CData'));
if (min(rgn(:,1))< 1 | max(rgn(:,1))>dims(1)),
    myWarnDlg('Must choose starting point within image boundaries');
    return;
end;

% Compute new coordinates
newCoords = zeros(3,1);
newCoords(1,:) = rgn(1,1);
newCoords(2,:) = rgn(1,2);
newCoords(3,:) = curSlice;

% for montage views, convert from montage coords to view coords
if checkfields(view, 'ui', 'montageSize')
    newCoords = montage2Coords(view,newCoords);
end

% Convert coords to canonical frame of reference
newCoords = curOri2CanOri(view,newCoords);

% get thesholds
cothresh = getCothresh(view);
phWindow = getPhWindow(view);
mapWindow = getMapWindow(view);
curScan = getCurScan(view);

% get data, above cothresh, between phthresh and mapthresh
% coherence
data = [];
if ~isempty(view.co) & cothresh~=0,
    tmp  = getCurData(view,'co',curScan);
    data = tmp>cothresh;
end;

% phase
if ~isempty(view.ph),
    tmp = getCurData(view,'ph',curScan);
    tmp = tmp>=phWindow(1) & tmp<=phWindow(2);
    if isempty(data),
        data = tmp;
    else,
        data = tmp.*data;
    end;
end;

% map
if ~isempty(view.map),
    tmp = getCurData(view,'map',curScan);
    tmp = tmp>=mapWindow(1) & tmp<=mapWindow(2);
    if isempty(data),
        data = tmp;
    else,
        data = tmp.*data;
    end;
end;

% find clusters
[imgLabel] = bwlabeln(data, 6);

% correct for upsample factor of ui
uiScale = upSampleFactor(view,curScan);
newCoords(1:2,:) = round(newCoords(1:2,:)./uiScale(1:2)');

% find our cluster
Label = imgLabel(newCoords(1),newCoords(2),newCoords(3));
if Label==0, % no data so quit
    return;
end;

% data with only our cluster
data = imgLabel==Label;

% apply upsample factor again for each slice
dims = viewSize(view);
sliceWithData = find(squeeze(max(max(data))));
datanew = zeros(dims);
for slice = sliceWithData, % loops...
    datanew(:,:,slice)=imresize(data(:,:,slice),dims(1:2),'nearest',0);
end;
data = datanew;

% convert matrix to coords
[i1, i2, i3] = ind2sub(size(data),find(data>.5));
newCoords = [i1 i2 i3]';

% Merge/remove coordinates
if sgn
    coords = mergeCoords(curCoords,newCoords);
else
    coords = removeCoords(newCoords,curCoords);
end
view.ROIs(view.selectedROI).coords = coords;


return;
