function plotMeanTSeries(view,scan)
%
% plotMeanTSeries(view,[scan])
% 
% Plots the mean tSeries for the current scan, averaging across
% all pixels (in all slices) in the current ROI.
%
% If you change this function make parallel changes in:
%   plotMultipleTSeries, plotFFTTseries, plotMultipleFFTSeries
%
% djh whenever
% 2005.04.04 AB added sections to transfer ROI to INPLANE from gray of flat
% so that plots could be made from the gray and flat views as well as from
% inplane.

global FLAT
global selectedFlat
global VOLUME
global selectedVOLUME
global INPLANE
global selectedINPLANE

% get scan params
if ieNotDefined('scan'),  scan = getCurScan(view); end
nCycles = numCycles(view,scan);
frameRate = getFrameRate(view,scan);

%%Specifics for Flat, Gray, or Inplane views - xform ROI to INPLANE view
switch view.viewType
case {'Volume' 'Gray'}   %%%For ROIs in Gray view - xform to inplane
    
    selectedVOLUME = viewSelected('volume'); 
    
    %initiate and / or select INPLANE window
    if isempty(INPLANE), 
        INPLANE{1} = initHiddenInplane;
        selectedINPLANE = 1;
    else
        selectedINPLANE = viewSelected('inplane'); 
    end
    
    % Set the Inplane scan number and datatype to match the Volume view. 
    curDataType = viewGet(VOLUME{selectedVOLUME},'datatypenumber');
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'datatypenumber',curDataType);
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'currentscan',scan);
    
    %Transfer current VOLUME ROI to INPLANE
    INPLANE{selectedINPLANE} = vol2ipCurROI(view,INPLANE{selectedINPLANE});
    
    
case {'Flat'} %%%For ROIs in Flat view - xform to inplane

    selectedFLAT = viewSelected('flat'); 
    
    %initiate and / or select VOLUME and INPLANE windows
    if isempty(VOLUME), 
        VOLUME{1} = initHiddenGray;
        VOLUME{1} = viewSet(VOLUME{1},'name','hidden');
        selectedVOlUME = 1;
    else
        selectedVOLUME = viewSelected('volume'); 
    end
    
    if isempty(INPLANE), 
        INPLANE{1} = initHiddenInplane;
        INPLANE{1} = viewSet(INPLANE{1},'name','hidden');
        selectedINPLANE = 1;
    else
        selectedINPLANE = viewSelected('inplane'); 
    end
    
    % Set the Inplane scan number and datatype to match the Flat view. 
    %         curScan =     viewGet(FLAT{selectedFLAT},'currentscan');
    curDataType = viewGet(FLAT{selectedFLAT},'datatypenumber');
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'datatypenumber',curDataType);
    INPLANE{selectedINPLANE} = viewSet(INPLANE{selectedINPLANE},'currentscan',scan);
    
    %Transfer current FLAT ROI to INPLANE
    INPLANE{selectedINPLANE} = flat2ipCurROI(view,INPLANE{selectedINPLANE},VOLUME{selectedVOLUME});
    
case {'Inplane'}   %%%For ROIs in INPLANE view - select inplane
    selectedINPLANE = viewSelected('inplane'); 
end

% Compute the mean tSeries
% We may have converted to the INPLANEs but if the data does not
% exist in the INPLANEs this will not work. Thus if that is the
% case try to get them from the current view.viewType
try
  ROIcoords = getCurROIcoords(INPLANE{selectedINPLANE});
  %disp(size(ROIcoords))
  tSeries = meanTSeries(INPLANE{selectedINPLANE},scan,ROIcoords);
  %disp(length(tSeries))
  nFrames = length(tSeries);
  %disp(nFrames)
catch
  % if that does not work try in the volume
   try
     ROIcoords = getCurROIcoords(VOLUME{selectedVOLUME});
     tSeries = meanTSeries(VOLUME{selectedVOLUME},scan,ROIcoords);
     nFrames = length(tSeries);
   catch
     rethrow(lasterror);
   end;
end;

  
% plot it

% selectGraphWin
newGraphWin

fontSize = 14;
t = linspace(0,(nFrames-1)*frameRate,nFrames)';
disp(size(t))
ROIname = view.ROIs(view.selectedROI).name;
disp(ROIname)
headerStr = ['Mean tSeries, ROI ',ROIname,', scan ',num2str(scan)];
set(gcf,'Name',headerStr);
plot(t,tSeries,'LineWidth',2);
nTicks = size(tSeries,1);
xtick = [0:nFrames*frameRate/nCycles:nFrames*frameRate];
set(gca,'xtick',xtick)
set(gca,'FontSize',fontSize)
xlabel('Time (sec)','FontSize',fontSize) 
ylabel('Percent modulation','FontSize',fontSize) 
set(gca,'XLim',[0,nFrames*frameRate]);
grid on

%Save the data in gca('UserData')
data.frameNumbers = t;
data.tSeries = tSeries;
set(gca,'UserData',data);

return;
