function blurTSeriesPlot
%
%   blurTSeriesPlot
%
% Blurs the tseries plot(s) in the current graph window. E.g., produced by
% plotting mean tSeries, or multiple tSeries Also runs on Single Cycle
% Plots.  
% 
% Re-written so that it might be extended in the future.  We should
% probably add identifiers to the userData structure in the plot windows.
% (BW)
%
% djh, 3/2001
global GRAPHWIN
if (isempty(GRAPHWIN) | GRAPHWIN==0)
  myErrorDlg('blurPlot: no graph to blur');
else
  set(0,'CurrentFigure',GRAPHWIN);
end
axisHandles = get(gcf,'Children');
for h = 1:length(axisHandles)
    subplot(axisHandles(h));
  
    % get the data
    data = get(gca,'userData');
    if isfield(data,'tSeries')
        typeOfPlot = 'tseries';
        whichHandle = h;
        data.time = data.frameNumbers;
        data.tSeries = blur(data.tSeries);       
    elseif isfield(data,'x') & isfield(data,'y')
        typeOfPlot = 'singlecycle';
        whichHandle = h;
        data.time = data.x;
        data.tSeries = blur(data.y);
    else
        myErrorDlg('blurPlot: cannot identify plot type.  You must add case to blurTseriesPlot')
    end
    % get plot properties
    xLim = get(gca,'xLim');
    yLim = get(gca,'yLim');
    xTick = get(gca,'xTick');
    yTick = get(gca,'yTick');
    xGrid = get(gca,'xGrid');
    yGrid = get(gca,'yGrid');

    fontName = get(get(gca,'xlabel'),'fontName');
    fontSize= get(get(gca,'xLabel'),'fontSize');
    xLabel = get(get(gca,'xLabel'),'String');
    yLabel = get(get(gca,'yLabel'),'String');
    titleStr = get(get(gca,'title'),'String');
    
    color = get(get(gca,'Children'),'Color');
    if iscell(color), color = color{1}; end
    lineWidth = get(get(gca,'Children'),'lineWidth');
    if iscell(lineWidth), lineWidth = lineWidth{1}; end
        
    switch lower(typeOfPlot)
        case 'tseries'
            p = plot(data.time,data.tSeries);
        case 'singlecycle'
            p = errorbar(data.time,data.tSeries,data.e);
        otherwise
    end
    
    % plot it
    set(p,'lineWidth',lineWidth);
    set(p,'Color',color);
    % reset properties
    set(gca,'xLim',xLim);
    set(gca,'yLim',yLim);
    set(gca,'xTick',xTick);
    set(gca,'yTick',yTick);
    set(gca,'xGrid',xGrid);
    set(gca,'yGrid',yGrid);
    xlabel(xLabel,'fontName',fontName,'fontSize',fontSize);   
    ylabel(yLabel,'fontName',fontName,'fontSize',fontSize);
    title(titleStr,'fontName',fontName,'fontSize',fontSize);
    set(gca,'UserData',data);
    
end

return

    
