function tc = mv_makeTCUI(mv,openNewFig);
%
% tc = mv_makeTCUI(mv,[openNewFig]);
%
% Create a time course UI from the voxels in 
% a multivoxel UI.
%
% If openNewFig is 1, will open a new figure w/ the UI.
% [default is 1]
%
% ras, 09/2005
if ieNotDefined('mv'), mv = get(gcf,'UserData'); end
if ieNotDefined('openNewFig'), openNewFig = 1;   end

roi = mv.roi;
roi.coords = mv.coords;

hI = initHiddenInplane(mv.params.dataType,mv.params.scans(1));

tc = tc_init(hI,roi,mv.params.scans,mv.params.dataType);

if openNewFig==1, tc = tc_openFig(tc); timeCourseUI; end

return