function scanParams = YNiC_GetScanParamsDicom(dirName,sessionName,scanList,nFrames,nSlices,SeriesDescript)
% function scanParams = GetScanParamsDicom(dirName,scanList,nFrames,nSlices);
% Populates the scanParams structure based on information read from the 
% dicom headers of the first file in each directory mentioned in 'scanList'
% Note that scanList is a list of directories (found under RawDicom)
% That contain the functional data - so it might be [3,4,5,6,7]
% ARW 043004 : Wrote it based on GetScanParams
% ABM 2006-07-24 : hacked to work with CDs burnt at YNiC
% ADG 2007-08-02 : hacked to automatically pass hard-coded dicom parameters
%   from artificially created DICOM files at YNiC  - changes triple
%   indented ( %%% )

scanParams = [];

if ~exist(dirName, 'dir')
  Alert('No raw data directory found');
  return
end

% Loop through checking that each sub dir exists. It's better to discover
% this now rather than halfway through the function
nFuncScans=length(scanList);
if(nFuncScans==0)
    error('No functional scan directories specified');
end

% Commented out this original version
% for t=1:length(scanList)
%     thisDir=[dirName,filesep,int2str(scanList(t))];
%     if (~exist(thisDir,'dir'))
%        fprintf('\nLooked for dir %s\n',thisDir);
%        error('Can''t find directory');
%    end
% end

for t=1:length(scanList)
    availdirs = dir([int2str(scanList(t)),'*']);
    for i = 1:length(availdirs)
        if availdirs(i).isdir == 1
            finishdir = availdirs(i).name;
        end
    end
    thisDir=[dirName,filesep,finishdir]; % Sloppy change to force it to work for now ABM 2006-07
    if (~exist(thisDir,'dir'))
       fprintf('\nLooked for dir %s\n',thisDir);
       error('Can''t find directory');
    end
end

for iScan=1:nFuncScans
   scanID=scanList(iScan);

   % Commented out this original version   
%     % Get the DICOM header of the first file to extract file information
%   fileSearchPath=[dirName,filesep,int2str(scanID),filesep,'*I1.DCM'];
%   sampleFileName=dir(fileSearchPath);
%   filePath=fullfile(dirName,int2str(scanID),sampleFileName.name);
%   dicomHeader=dicominfo(filePath);

     % Get the DICOM header of the first file to extract file information
     % Sloppy(ish) change to force it to work for now ABM 2006-08
  fileSearchPath=[dirName,filesep,finishdir,filesep,'MR000001'];
  sampleFileName=dir(fileSearchPath);
  filePath=fullfile(dirName,finishdir,sampleFileName.name);
  disp(filePath);
  %%%dicomHeader=dicominfo(filePath);
   
  scanParams(iScan).PfileName = ['no pfile : DICOM series ',int2str(scanID)];
  scanParams(iScan).totalFrames = nFrames;
  scanParams(iScan).firstName='';
  
  % In some versions of matlab (6?) the following header
  % is'PatientName' in others it's 'PatientsName'.
  % Go figure...
  
%%%try   %in Matlab7 it extract PatientName while in matlab 6 Patient!s!Name 
  %%%scanParams(iScan).lastName=dicomHeader.PatientsName.FamilyName;
%%% catch 
      %%%scanParams(iScan).lastName=dicomHeader.PatientName.FamilyName;
%%%end
    scanParams(iScan).lastName='SURNAME';
    
  %%%scanParams(iScan).date=dicomHeader.StudyDate;
  scanParams(iScan).date='01012001';
  %%%scanParams(iScan).time=dicomHeader.StudyTime;
  scanParams(iScan).time='1200';
  scanParams(iScan).junkFirstFrames = 0;
  scanParams(iScan).nFrames = nFrames;
  scanParams(iScan).slices = [1:nSlices];
  %%%scanParams(iScan).fullSize = [dicomHeader.Height, dicomHeader.Width];
  scanParams(iScan).fullSize = [192, 192];
  scanParams(iScan).cropSize = [];
  scanParams(iScan).crop = [];
  %%%dxy = dicomHeader.PixelSpacing(1);
  %%%scanParams(iScan).voxelSize = [dxy, dxy, dicomHeader.SliceThickness];
  scanParams(iScan).voxelSize = [3,3,3];
  scanParams(iScan).effectiveResolution = scanParams(iScan).voxelSize;
  scanParams(iScan).reconParams.slquant=nSlices;
  %%%scanParams(iScan).reconParams.FOV=dicomHeader.Width*dicomHeader.PixelSpacing(1);
  scanParams(iScan).reconParams.FOV = 192;
  %%%scanParams(iScan).reconParams.equivMatSize=dicomHeader.Rows;
  scanParams(iScan).reconParams.equivMatSize=64;
  %%%scanParams(iScan).reconParams.sliceThickness=dicomHeader.SliceThickness;
  scanParams(iScan).reconParams.sliceThickness=3;
  scanParams(iScan).reconParams.nframes=nFrames;
 
  %%%if isfield(dicomHeader,'NumberOfAverages')  
    %%%scanParams(iScan).reconParams.nshots=dicomHeader.NumberOfAverages;
  %%%else 
	scanParams(iScan).reconParams.nshots=1;
	disp('Assuming 1-shot and popluating scan params as such ')
  %%%end
  
  %%%if isfield(dicomHeader,'RepetitionTime')  
	%%%scanParams(iScan).framePeriod = dicomHeader.RepetitionTime/1000;
	%%%scanParams(iScan).reconParams.TR=dicomHeader.RepetitionTime/1000;
  %%%else 
	scanParams(iScan).framePeriod = 3;
	scanParams(iScan).reconParams.TR = 3;
	disp('Assuming TR = 3s and popluating scan params as such ')
  %%%end
  	
  %%%if isfield(dicomHeader,'EchoTime')  
    %%%scanParams(iScan).reconParams.TE = dicomHeader.EchoTime;
  %%%else 
	scanParams(iScan).reconParams.TE = 30;
	disp('TE = 30 and popluating scan params as such ')
  %%%end
	
  
  %%%scanParams(iScan).dicomHeader=dicomHeader;
  
end  
