function OK = UpdateEditDataType(topH)

% OK = UpdateEditDataType(topH);
%
% Reads off all the editable fields in the dialog and evaluates
% them into the dataType structure.
%
% DBR 4/99

uiData = get(topH, 'UserData');

iScan = uiData.iScan;
iStr = int2str(iScan);

nFields = length(uiData.scanData);
ok = [];
for iField=1:nFields
  editFlag = uiData.scanData(iField).edit;
  if editFlag
    hContent = uiData.scanData(iField).handle;
    fName = uiData.scanData(iField).field;
    curValue = eval(['uiData.dataType.scanParams(', iStr, ').', fName]);
    if isstr(curValue)
      evalStr = ['res = ''', get(hContent, 'string'), ''';'];
    else
      evalStr = ['res = ', get(hContent, 'string'), ';'];
    end
    ok1 = 1;
    eval(evalStr, 'ok1 = 0;');
    if ok1
        set(hContent, 'string', mat2str(res));          
        eval(['uiData.dataType.scanParams(', iStr, ').', fName, ' = res;']);
    else
      label = uiData.scanParams(iField).label;
      Alert(['Problems evaluating "', label, '"']); 
      set(hContent, 'string', mat2str(curValue));
    end
    ok = [ok, ok1];
  end
end

nFields = length(uiData.blockData);
ok = [];
for iField=1:nFields
  editFlag = uiData.blockData(iField).edit;
  if editFlag
    hContent = uiData.blockData(iField).handle;
    fName = uiData.blockData(iField).field;
    curValue = eval(['uiData.dataType.blockedAnalysisParams(', iStr, ').', fName]);
    if isstr(curValue)
      evalStr = ['res = ''', get(hContent, 'string'), ''';'];
    else
      evalStr = ['res = ', get(hContent, 'string'), ';'];
    end
    ok1 = 1;
    eval(evalStr, 'ok1 = 0;');
    if ok1
      % Check the editable fields for consistency and correct
      % if necessary:
      switch fName
      case 'blockedAnalysis'
        res = round(double(res)); % Force integer
        if (res < 0) | (res > 1)
          res = 0;
        end
      case 'detrend'
        res = round(double(res)); % Force integer
        if (res < -1) | (res > 2)
            res = 0;
        end
      case 'inhomoCorrect'
        res = round(double(res)); % Force integer
        if (res < 0) | (res > 3)
          res = 0;
        end
      case 'nCycles'
        res = round(abs(double(res))); % Force positive integer
      end
      set(hContent, 'string', mat2str(res));          
      eval(['uiData.dataType.blockedAnalysisParams(', iStr, ').', fName, ' = res;']);
    else
      label = uiData.blockData(iField).label;
      Alert(['Problems evaluating "', label, '"']); 
      set(hContent, 'string', mat2str(curValue));
    end
    ok = [ok, ok1];
  end
end

nFields = length(uiData.eventData);
ok = [];
for iField=1:nFields
  editFlag = uiData.eventData(iField).edit;
  if editFlag
    hContent = uiData.eventData(iField).handle;
    fName = uiData.eventData(iField).field;
    curValue = eval(['uiData.dataType.eventAnalysisParams(', iStr, ').', fName]);
    if isstr(curValue)
      evalStr = ['res = ''', get(hContent, 'string'), ''';'];
    else
      evalStr = ['res = ', get(hContent, 'string'), ';'];
    end
    ok1 = 1;
    eval(evalStr, 'ok1 = 0;');
    if ok1
      % Check the editable fields for consistency and correct
      % if necessary:
      switch fName
      case 'eventAnalysis'
        res = round(res); % Force integer
        if (res < 0) | (res > 1)
          res = 0;
        end
      end
      set(hContent, 'string', mat2str(res));          
      eval(['uiData.dataType.eventAnalysisParams(', iStr, ').', fName, ' = res;']);
    else
      label = uiData.eventData(iField).label;
      Alert(['Problems evaluating "', label, '"']); 
      set(hContent, 'string', mat2str(curValue));
    end
    ok = [ok, ok1];
  end
end

set(topH, 'UserData', uiData);
if nFields > 0
  OK = all(ok);
else
  OK = 1;
end
