function OK = UpdateEdit(topH)

% OK = UpdateEdit(topH);
%
% Reads off all the editable fields in the dialog and evaluates
% them into the session structure.
%
% DBR 4/99


uiData = get(topH, 'UserData');
nTop = length(uiData.topData);
for iField=1:nTop
  editFlag = uiData.topData(iField).edit;
  if editFlag
    eval(['res = ''', get(uiData.topData(iField).handle, 'string'), ''';']);
    eval(['uiData.session.', uiData.topData(iField).field, ' = res;']);
  end
end

iScan = uiData.iScan;
iStr = int2str(iScan);
nScan = length(uiData.scanData);
ok = [];
for iField=1:nScan
  editFlag = uiData.scanData(iField).edit;
  if editFlag
    hContent = uiData.scanData(iField).handle;
    fName = uiData.scanData(iField).field;
    curValue = eval(['uiData.session.functionals(', iStr, ').', fName]);
    if isstr(curValue)
      evalStr = ['res = ''', get(hContent, 'string'), ''';'];
    else
      evalStr = ['res = ', get(hContent, 'string'), ';'];
    end
    ok1 = 1;
    eval(evalStr, 'ok1 = 0;');
    if ok1
      % Check the editable fields for consistency and correct
      % if necessary:
      switch fName
      case 'junkFirstFrames'
        res = round(abs(res)); % Force positive integer input
        totalFrames = uiData.session.functionals(iScan).totalFrames;
        if res >= totalFrames
          res = totalFrames - 1;
        end
        uiData.session.functionals(iScan).nFrames = totalFrames - res;
      case 'nFrames'
        res = round(abs(res)); % Force positive integer input
        availFrames = uiData.session.functionals(iScan).totalFrames - ...
          uiData.session.functionals(iScan).junkFirstFrames;
        if res > availFrames
          res = availFrames;
        end
      case 'slices'
        res = unique(round(abs(res))); % Force positive integer input
        nInplaneSlices = uiData.session.inplanes.nSlices;
        nSlices = uiData.session.functionals(iScan).reconParams.slquant;
        iOK = find(res >= 1 & res <= nInplaneSlices);
        if length(iOK) == 0
          res = 1:nSlices;
        else
          res = res(iOK);
        end
        res = res(1:nSlices);
      end
      set(hContent, 'string', mat2str(res));          
      eval(['uiData.session.functionals(', iStr, ').', fName, ' = res;']);
    else
      label = uiData.scanData(iField).label;
      Alert(['Problems evaluating "', label, '"']); 
      set(hContent, 'string', mat2str(curValue));
    end
    ok = [ok, ok1];
  end
end

set(topH, 'UserData', uiData);
if nScan > 0
  OK = all(ok);
else
  OK = 1;
end
