function [tsA, tsB] = LoadRecon(scanParams, fName, slice, rotFlag, endianFlag)
% [tsA, tsB] = LoadRecon(scanParams, fName, slice, rotFlag, endianFlag]);
%
% Load the reconstructed time series produced by Gary Glover's
% spiral reconstruction code.
%
% DBR 8/01
% ras 03/05: added Endian Flag, removed comp flag since
% the complex code doesn't even seem to have worked for
% more than 4 years!
if ~exist('compFlag'), compFlag = 0; end
if ~exist('rotFlag'), rotFlag = 0; end

if ieNotDefined('endianFlag') | endianFlag==0
    endianFlag = 'ieee-le';
end

fNames = {scanParams.PfileName};
[p, name, ext] = fileparts(fName);
scan = strmatch(name, fNames);
nFrames = scanParams.totalFrames;
fSize = scanParams.fullSize;
offset = prod(fSize) * 2 * (slice - 1) * nFrames;

% Read in magnitude component:
mN = fopen(fName, 'r', endianFlag);
tsA = zeros([nFrames, fSize]);
fseek(mN, offset, 0); % Skip to desired slice
for f=1:nFrames
    img = fread(mN, fSize, 'int16', endianFlag)';
    if rotFlag, img = rot90(img, -1); end
    tsA(f, :, :) = img;
end
fclose(mN);
% delete(fnMag);
tsB = [];

return


% Way Old Code:
% (This was for reading complex parts of functionals)
% else
%     % *** This whole section is now busted ***
%     % *** see David Ress for details ***
%     % Read in real & imaginary components:
%     fnReal = [fName '.r'];
%     rN = fopen(fnReal, 'r', 'ieee-be');
%     tsA = zeros([nFrames, fSize]);
%     for f=1:nFrames
%         fseek(rN, offset, 0); % Skip to desired slice
%        % if slice > 1 for iS=1:slice-1 dummy = fread(rN, fSize, 'int16');       % end; end
%         tsA(f, :, :) = fread(rN, fSize, 'int16')';
%         fseek(rN, offset2, 0); % Skip to next frame
%     end
%     fclose(rN);
%     delete(fnReal);
%     fnImag = [fName '.i'];
%     iN = fopen(fnImag, 'r', 'ieee-be');
%     tsB = zeros([nFrames, fSize]);
%     for f=1:nFrames
%         fseek(iN, offset, 0); % Skip to desired slice
%         tsB(f, :, :) = fread(iN, fSize, 'int16')';
%         fseek(iN, offset2, 0); % Skip to next frame
%     end
%     fclose(iN);
%     %   delete(fnImag);
