function EditDataType_CopyFields(topH);
%
% For the Edit Data Type dialog, copy fields to user-selected scans.
%
% EditDataType_CopyFields(topH);
%
%
% ras, 02/06.

% Unpack the user data from the edit figure
uiData = get(topH, 'UserData');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% have the user select the target scans %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
scanList = {uiData.dataType.scanParams.annotation};
for i=1:length(scanList)
    scanList{i} = sprintf('Scan %i: %s', i, scanList{i});
end
title = 'Copy Current Params to which scans?';
[tgtScans, ok] = listdlg('PromptString', title,...
    'ListSize', [300 400], 'ListString',scanList, ...
    'InitialValue', 1 ,'OKString', 'OK');
if ~ok, return; end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% copy over the fields, one by one %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nScans = length(uiData.dataType.scanParams); % Number of scans in session
ok = [];
for iScan = tgtScans
    
    % Scan Params Fields
    nFields = length(uiData.scanData); % Number of scan edit fields
    for iField=1:nFields
        editFlag = uiData.scanData(iField).edit;
        if editFlag
            hContent = uiData.scanData(iField).handle;
            fName = uiData.scanData(iField).field;
            origValue = eval(['uiData.original.scanParams(', int2str(iScan), ').', fName]);
            if isstr(origValue)
                evalStr = ['res = ''', get(hContent, 'string'), ''';'];
            else
                evalStr = ['res = ', get(hContent, 'string'), ';'];
            end
            ok1 = 1;
            label = uiData.scanData(iField).label;
            catchStr = ['Alert(''Problems evaluating ', label, '''); ok1 = 0;'];
            eval(evalStr, catchStr);
            ok = [ok, ok1];
            if ok1
                eval(['uiData.dataType.scanParams(', int2str(iScan), ').', ...
                        uiData.scanData(iField).field, ' = res;']);
            else
                break % stop copying if error encountered
            end
        end
    end
    
    % Blocked Analysis Fields
    nFields = length(uiData.blockData); % Number of block edit fields
    for iField=1:nFields
        editFlag = uiData.blockData(iField).edit;
        if editFlag
            hContent = uiData.blockData(iField).handle;
            fName = uiData.blockData(iField).field;
            origValue = eval(['uiData.original.blockedAnalysisParams(', int2str(iScan), ').', fName]);
            if isstr(origValue)
                evalStr = ['res = ''', get(hContent, 'string'), ''';'];
            else
                evalStr = ['res = ', get(hContent, 'string'), ';'];
            end
            ok1 = 1;
            label = uiData.blockData(iField).label;
            catchStr = ['Alert(''Problems evaluating ', label, '''); ok1 = 0;'];
            eval(evalStr, catchStr);
            ok = [ok, ok1];
            if ok1
                eval(['uiData.dataType.blockedAnalysisParams(', int2str(iScan), ').', ...
                        uiData.blockData(iField).field, ' = res;']);
            else
                break % stop copying if error encountered
            end
        end
    end
    
    % Event fields
    nFields = length(uiData.eventData); % Number of event edit fields
    for iField=1:nFields
        editFlag = uiData.eventData(iField).edit;
        if editFlag
            hContent = uiData.eventData(iField).handle;
            fName = uiData.eventData(iField).field;
            origValue = eval(['uiData.original.eventAnalysisParams(', int2str(iScan), ').', fName]);
            if isstr(origValue)
                evalStr = ['res = ''', get(hContent, 'string'), ''';'];
            else
                evalStr = ['res = ', get(hContent, 'string'), ';'];
            end
            ok1 = 1;
            label = uiData.eventData(iField).label;
            catchStr = ['Alert(''Problems evaluating ', label, '''); ok1 = 0;'];
            eval(evalStr, catchStr);
            ok = [ok, ok1];
            if ok1
                eval(['uiData.dataType.eventAnalysisParams(', int2str(iScan), ').', ...
                        uiData.eventData(iField).field, ' = res;']);
            else
                break % stop copying if error encountered
            end
        end
    end
end

if all(ok)
    set(topH, 'UserData', uiData);
end

return
