function view = helpMenu(view);
% [view or menu handle] = helpMenu([view]);
%
% Attach a menu containing help-related callbacks to a mrVista view or
% other figure.
%
% If a view is provided, attaches the menu to that view and returns
% the modified view structure. If no args are provided, attaches the
% help menu to the current figure and returns a handle to the menu.
% 
% ras, 11/07/05.

% if ieNotDefined('view'), view = getSelectedInplane; end



% a mrVista view shouldn't be required for this stuff; but if one

% is provided, make the main figure current, so the menus are attached

% to that figure:

if exist('view','var') & ~isempty(view)

    figure(view.ui.figNum);

end



% create the top-level menu

hmenu = uimenu(gcf, 'Label', 'Help', 'Separator', 'on');



% call up mrVista home page:

cb = 'web http://white.stanford.edu/~sweta/VistaLab/Manual/mrvista.html';

uimenu(hmenu, 'Label', 'mrVista Home Page', 'Callback', cb);



% call up Rory's mrVista Guide:

cb = 'web(''http://white.stanford.edu/~sayres/mrvista/mrVista%20Guide.htm'')';

uimenu(hmenu, 'Label', 'mrVista Guide [in progress]', 'Callback', cb);



% identify the callback to a menu item:

uimenu(hmenu, 'Label', 'Identify Callback for a Menu Item', ...
    'Separator', 'on', 'Callback', 'helpFindCallback;');



% if no view provided, return a handle to the menu

if ieNotDefined('view')

    view = hmenu;

end



return

