function view = saveROI(view,ROI,loadFromDefaultFlag)
%
% view = saveROI(view, ROI, loadFromDefaultFlag)
%
% Saves ROI to a file.
%
% ROI: ROI structure
%
% djh, 1/24/98
% gmb, 4/25/98 added dialog box
% ARW 10/06/05 : Added default ROI path option
% (see also roiDir)
if (ieNotDefined('loadFromDefaultFlag'));
    loadFromDefaultFlag=0;
end


ROIname=ROI.name;
pathStr=fullfile(roiDir(view,loadFromDefaultFlag),ROIname);
if check4File(pathStr)
    saveFlag = questdlg(['ROI "',ROIname,'" already exists.  Overwrite?'],'Save ROI','Yes','No','No');
else
    saveFlag = 'Yes';
end

if strcmp(saveFlag,'Yes')
    disp(['Saving ROI "',ROIname,'".']);
    save(pathStr,'ROI');
else
    disp('ROI not saved.');
end

return;