function savePrefs(view)
%
% savePrefs(view)
%
% Saves UI settings in userPrefs file.  There's a separate
% userPrefs file for each view.
%
% djh, 1/19/98

% Modifications:
%
% djh, 4/99.
% - Removed overlayClip.  
% - Added mapWindow.
% - Saves all slice numbers for all 3 slice orientations.
% bw, 12.08.00
% - replaced '/' with filesep
% ras, 2.11.04
% - expanded to save a bit more information:
%   1) The position of the view figure on the screen
%   2) Color map settings for the different view modes
%   3) ROI view preference: outline vs. filled, selected vs. all vs. hide
% Ress, 8/05
% Fixed dimension-swap bug in saving of zoom field.

pathStr=fullfile(viewDir(view),'userPrefs');

displayMode = view.ui.displayMode;
cothresh = getCothresh(view);
phWindow = getPhWindow(view);
mapWindow = getMapWindow(view);
curScan = getCurScan(view);
curSlice = getCurSlice(view);
dataTypeName = getDataTypeName(view);

% 01/05: trying to migrate to using 
% brightness/contrast, but be back-
% compatible
if isfield(view.ui,'anatMin')
    anatClip = getAnatClip(view);
    contrast = diff(anatClip);
    brightness = 0.5;
elseif isfield(view.ui,'brightness')
    brightness = viewGet(view,'brightness');
    contrast = viewGet(view,'contrast');
    anatClip = [0 contrast];
end

% 05/05: try to record zoomBounds as well
if checkfields(view,'ui','zoom')
    zoomBounds = view.ui.zoom;
else
    dims = viewSize(view);
    % NOTE: the axis command operates in image logical (x, y, z) ordering.
    % The dims command returns matlab-style (y, x, z) ordering, so we have
    % to flip these here.
    switch view.viewType
        case {'Inplane','Flat'},
            zoomBounds = [1 dims(2) 1 dims(1)];
        case {'Volume','Gray'},
            zoomBounds = [1 dims(2); 1 dims(1); 1 dims(3)];
    end
end


% mode colormap info
anatMode = view.ui.anatMode;
coMode = view.ui.coMode;
ampMode = view.ui.ampMode;
phMode = view.ui.phMode;
mapMode = view.ui.mapMode;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ROI info                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
showROIs = view.ui.showROIs;

if checkfields(view,'ui','filledPerimeter')
    filledPerimeter = view.ui.filledPerimeter;
else
    filledPerimeter = 0;
end

if checkfields(view,'ui','selRoiColor')
    selRoiColor = view.ui.selRoiColor;
else
    selRoiColor = [1 1 1]; % white default
end


% window position info
set(view.ui.windowHandle,'Units','Normalized');
winPos = get(view.ui.windowHandle,'Position');


switch view.viewType
case 'Inplane'
    if checkfields(view,'ui','montageSize')
        % record montage size
        montageSize = get(view.ui.montageSize.sliderHandle,'Value');
    else
        montageSize = 1;
    end
    
	save(pathStr,'displayMode','cothresh','phWindow','mapWindow','anatClip',...
		'curScan','curSlice','dataTypeName','anatMode','coMode','ampMode',...
        'phMode','mapMode','brightness','contrast','showROIs','winPos',...
        'zoomBounds','montageSize','filledPerimeter','selRoiColor');
case {'Volume','Gray'}
	curSlices = zeros(1,3);
	for sliceOri = 1:3
		curSlices(sliceOri) = ...
			str2num(get(view.ui.sliceNumFields(sliceOri),'String'));
	end
	curSliceOri = getCurSliceOri(view);
	save(pathStr,'displayMode','cothresh','phWindow','mapWindow','anatClip',...
		'curScan','curSlice','dataTypeName','curSlices','curSliceOri','anatMode',...
        'coMode','ampMode','phMode','mapMode','showROIs','winPos','zoomBounds',...
        'filledPerimeter','selRoiColor');
case 'Flat'
   
    if (~isfield(view.ui,'filledPerimeter'))
        view.ui.filledPerimeter=1;
    end
    

    % Also save rotation , LR flip 
    [rotations,flipLR]=getFlatRotations(view);
    
    save(pathStr,'displayMode','cothresh','phWindow','mapWindow','anatClip',...
		'curScan','curSlice','dataTypeName','rotations','flipLR','filledPerimeter',...
        'anatMode','coMode','ampMode','phMode','mapMode','showROIs','winPos',...
        'zoomBounds','selRoiColor');
end
disp('Saved preferences');

return;

