function saveParameterMap(view, pathStr, forceSave, saveCmap)
%
% function saveParameterMap(view, [pathStr], [forceSave], [saveCmap])
%
% save the currently set parameter map in a user specified file
%
% If you change this function make parallel changes in:
%   saveCorAnal, saveParameterMap
%
% If forceSave is set to 1, will not prompt before saving.
%
% saveCmap: if set to 1, will save the map mode parameters as well
% (such as the color map, and the clip mode). [Default: 1, save it]
% 
% 
% rmk, 1/12/99
% djh, 2/2001, mrLoadRet 3.0
% ras, 1/05, added forceSave
% ras, 11/05, added saveCmap
if ieNotDefined('forceSave'),       forceSave = 0;     end
if ieNotDefined('saveCmap'),        saveCmap = 1;       end
if isempty(view.map)
    warndlg('No Parameter Map is set!');
    return;
end
% if no filename, bring up a dialog box
if ieNotDefined('pathStr')
    if ~isempty(view.mapName)
        pathStr = fullfile(dataDir(view),[view.mapName,'.mat']);
    else
        pathStr = putPathStrDialog(dataDir(view),'Parameter map filename:','*.mat');
   end
end
if exist('pathStr','var')
    % check if file already exists:
    if exist(pathStr,'file') & forceSave==0
        saveFlag = questdlg(['File "',pathStr,'" already exists.  Overwrite?'],'Save File','Yes','No','No');
    else
        saveFlag = 'Yes';
    end
    
    if strcmp(saveFlag,'Yes')
        disp(['Saving Parameter Map: ',pathStr])
        map=view.map;
        mapName=view.mapName;
        save(pathStr,'map','mapName');
    else
        disp('Parameter map not saved.');
    end
end
if saveCmap==1 & checkfields(view, 'ui', 'mapMode')
    cmap =       view.ui.mapMode.cmap;
    clipMode =   view.ui.mapMode.clipMode;
    numColors =  view.ui.mapMode.numColors;
    numGrays = view.ui.mapMode.numGrays;
    
    save(pathStr, 'cmap', 'clipMode', 'numColors', 'numGrays', '-append');
end

return
