function view = loadROI(view,filename,select,clr,absPathFlag,defaultPathFlag)
%
% view = loadROI(view,filename,[select],[color])
%
% Loads ROI from a file, adds it to the ROIs field of view, and
% selects it.
%
% filename: cell array of strings (e.g, 'V1L' that determines ROI filename)
% select: if non-zero, chooses the new ROI as the selectedROI
%         (default=1).
% color: sets color for drawing the ROI.  If unspecified, uses
%        the color saved in the ROI file.  If no color is saved
%        in the ROI file, uses 'b' as the default.
%
% djh, 1/24/98 
% rmk, 1/12/99 changed to accomodate loading multiple ROIs at once
% dbr, 1/13/99 allow single string spec for ROI name.

% dbr, 10/3/00 Use absolute path specification.
% rfd, 2003.08.14 missing files now generate warnings rather than errors.
% This has the added benefit of not leaving the UI in an ugly state when
% some files are not found.
% arw, 02/13/04 Added flag to allow loading ROIs using an absolute path
% name.
if notDefined('select'),            select=1;           end 
if notDefined('absPathFlag'),       absPathFlag=0;      end
if notDefined('defaultPathFlag'),   defaultPathFlag=0;  end


% Force filename input to be a unity length cell array:
if (~iscell(filename) & ~isempty(filename))
    filename = {filename};
end
 
for i=1:length(filename)
    if (absPathFlag)
        %disp('Using absolute path for ROI names');        
        pathStr = filename{i};
    else
%         disp('Looking for ROI names in roiDir');
         pathStr = fullfile(roiDir(view,defaultPathFlag),filename{i});
            %pathStr=filename{i}
    end
    
    if check4File(pathStr) %changed from check4file to capital F (BZL)
        disp(['loading ',filename{i}]);
        thisROI=load(pathStr);
        
        % Coerce to current format with viewType instead of viewName
        if isfield(thisROI.ROI,'viewName')
            thisROI.ROI = rmfield(thisROI.ROI,'viewName');
            thisROI.ROI.viewType = view.viewType;
        end
        
        if exist('clr','var')
            thisROI.ROI.color=clr;
        end
        if ~isfield(thisROI.ROI,'color')
            thisROI.ROI.color='b';
        end
        
        % Check to see if ROI filename matches the ROI.name. If not, force
        % ROI.name to be ROI.filename
        [ROIpathname ROIfilename ROIextn dummy] = fileparts(filename{i});
                
        if (~strcmp(thisROI.ROI.name,ROIfilename))     
             fprintf('\nWarning! ROI.name %s does not match the filename %s.\nI will make the two match by changing ROI.name (but I will not re-save the ROI).',thisROI.ROI.name,ROIfilename);
             thisROI.ROI.name=ROIfilename;
         end
         
        view = addROI(view,thisROI.ROI,select);
        % disp(thisROI.ROI)      
    else
        % disp(pathStr);
        error('** Pathstr does not exist **');
        
        %warning([pathStr,' does not exist ***']);
    end
end

disp('Done loading');
