function view = loadPrefs(view)
%
% loadPrefs(view)
%
% Loads UI settings in userPrefs file.  There's a separate
% userPrefs file for each view.
%
% loadPrefs.m
% djh, 1/19/98
% Modifications:
% djh, 4/99.  
% - Removed overlayClip.  
% - Added mapWindow.
% - Sets slice numbers for all 3 slice orientations
% ras, 02/04
% - expanded to load a bit more information (if previously saved):
%   1) The position of the view figure on the screen
%   2) Color map settings for the different view modes
%   3) ROI view preference: outline vs. filled, selected vs. all vs. hide

pathStr=fullfile(viewDir(view),'userPrefs.mat');
if exist(pathStr,'file');
    disp(['Loading user preferences: ',pathStr])
    load(pathStr);
else
    disp(['Could not find ',pathStr])
    return;
end

view.ui.displayMode = displayMode;
setCothresh(view,cothresh);
setPhWindow(view,phWindow);
setMapWindow(view,mapWindow);
view = selectDataType(view,dataTypeName);
view = setCurScan(view,curScan);

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ROI info                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist('zoomBounds','var')
    view.ui.zoom = zoomBounds;
end

if(~exist('filledPerimeter','var'))
    filledPerimeter=0;
end
view.ui.filledPerimeter=filledPerimeter;

if(~exist('selRoiColor','var'))
    selRoiColor=[0 0 1];
end
view.ui.selRoiColor=selRoiColor;


switch view.viewType
    case 'Inplane'
        setCurSlice(view,curSlice);
        
        % check for montage size setting
        if exist('montageSize','var') & checkfields(view,'ui','montageSize')
            setSlider(view, view.ui.montageSize, montageSize, 0);
        end
    case {'Volume','Gray'}        
        for sliceOri = 1:3            
            setCurSliceOri(view,sliceOri);
            setCurSlice(view,curSlices(sliceOri));
        end
        setCurSliceOri(view,curSliceOri);
        setCurSlice(view,curSlice);
    case 'Flat'
        
        % The following two fields may not exist in older preference files
        if (~exist('rotations','var'))
            rotations=[0 0];
        end
        if (~exist('flipLR','var'))
            flipLR=[0 0];
        end
        
        view=setFlatRotations(view,rotations,flipLR);
        setCurSlice(view,curSlice);
        setImageRotate(view,rotations(curSlice)/(180/pi));
end

% the following info was saved only recently -- only load if available
if exist('anatMode','var')    view.ui.anatMode = anatMode;      end
if exist('coMode','var')      view.ui.coMode = coMode;          end
if exist('ampMode','var')     view.ui.ampMode = ampMode;        end
if exist('phMode','var')      view.ui.phMode = phMode;          end
if exist('mapMode','var')     view.ui.mapMode = mapMode;        end
if exist('showROIs','var')    view.ui.showROIs = showROIs;      end

if exist('winPos','var')
    set(view.ui.windowHandle,'Units','Normalized','Position',winPos);
end

if exist('anatClip','var') 
    if isfield(view.ui,'anatMin')
        setAnatClip(view,anatClip);
    elseif isfield(view.ui,'contrast')
        view = viewSet(view,'contrast',diff(anatClip));
    end
end

if exist('brightness','var') & isfield(view.ui,'brightness')
    view = viewSet(view,'brightness',brightness);
end

view = refreshScreen(view);

disp('Loaded prefs');

return;
