function view=loadParameterMap(view,pathStr)
% function loadParameterMap(view,[pathStr])
%
% load and set parameter map in a user specified file
%
% pathStr: optional path to parameter map file. Default: prompt user
%
% rmk, 1/12/99
% djh, 2/21/2001, modified to use dataDir and getPathStrDialog
% ras, 02/04, creates an estimated co, amp, and ph fields if they don't
% exist, b/c mrLoadRet is snotty about using parameter maps alone.
%
% ras, 03/11/04: In working with contrast maps, I've found it useful to have 
%  independent statistical threshold and effect size maps -- to restrict
% the map overlay according to the threshold, but to color-code according
% to the effect size. This is analgous to thresholding by coherence, but
% color-coding by amplitude. In this way, for instance, one could leave the
% mapWin at full range, slide the cothresh sliand see both highly correlated
% and anticorrelated regions for a given contrast. 
% So, I've made some param map files that have a 'co' field saved with the
% map and mapName vars. This field, when loaded, would replace the co field
% for the corAnal.
% ARW: It didn't seem right that we estimated co (or had it saved in the
% param file). Instead, we fill co with ones so that it behaves correctly
% ras: Yeah, it's a hack, b/c the variable doesn't generally represent coherence, 
% but for event-related analyses, it's often pretty useful to have the
% two different ways of thresholding. While a long-term solution is to have
% a more generalized display method (which is in the nascent mrVista2
% viewer), it's still nice to have it for now.
%
% ras, 11/15/05: added ability to load map parameters, such as the color
% map and clip modes, which may be saved along with the map.

if ~exist('pathStr','var')
    pathStr = getPathStrDialog(dataDir(view),'Choose parameter map file name','*.mat');
end

if ~exist(pathStr,'file')
    warning(['No ',pathStr,' file'])
    view.map = [];
    view.mapName = '';
else
    disp(['Loading Parameter Map: ',pathStr]);
    load(pathStr);
    
    view = setParameterMap(view,map,mapName);
    view = makeCorAnalFields4Map(view);
    
    if exist('co','var')
        for scan = 1:numScans(view)
            if ~isempty(map{scan})
                view.co{scan} = co{scan};
                s = scan;
            end
        end
    end
    
    % if parameters about the view mode are saved, load these in as well
    if exist('cmap','var'), view.ui.mapMode.cmap = cmap; end
    if exist('clipMode','var'), view.ui.mapMode.clipMode = clipMode; end
    if exist('numColors','var'), view.ui.mapMode.numColors = numColors; end
    if exist('numGrays','var'), view.ui.mapMode.numGrays = numGrays; end
    
    % refresh (if this isn't a hidden view -- no ui struct)
    if isfield(view,'ui')
        view=setDisplayMode(view,'map');
        refreshScreen(view);
    end
end

return