function view=loadMeanMap(view)
%
% view=loadMeanMap(view)
%
% Checks view.mapName field of the view structure.  
% If view.mapName is not "meanMap", then load it,
% and call setParameterMap.
%
% If you change this function make parallel changes in:
%   loadCorAnal, loadResStdMap, loadStdMap, loadMeanMap
%
% djh, 7/16/99, modified from loadCorAnal
% ras, 1/21/05, computes mean map if it doesn't exists

if ~strcmp(view.mapName,'meanMap')
    pathStr=fullfile(dataDir(view),'meanMap.mat');
    if ~exist(pathStr,'file')
        % go ahead and compute mean map for all scans
        % (disk space is cheap, processors fast, etc)
        view = computeMeanMap(view,0);
    else
        disp(['Loading meanMap from ',pathStr]);
        load(pathStr);
        view=setParameterMap(view,map,'meanMap');
    end
end

return
