function view=filesMenu(view)
%
% view=filesMenu(view)
% 
% Set up the callbacks for the FILE menu
% 
% djh, 1/9/98

mrGlobals

fileMenu = uimenu('Label','File','separator','on');

% Load Anatomies callback:
%  view=loadAnat(view);
%  view=refreshScreen(view);
callBackstr=[view.name,'=loadAnat(',view.name,'); ',...
      view.name,'=refreshScreen(',view.name,');'];
uimenu(fileMenu,'Label','Load Anatomies','Separator','off',...
   'CallBack',callBackstr);

% Change vAnatomyPath callback:
%  vANATOMYPATH = getvAnatomyPath(mrSESSION.subject,1);
callBackstr=['vANATOMYPATH=getvAnatomyPath(mrSESSION.subject,1);'];
uimenu(fileMenu,'Label','Select vAnatomy','Separator','on',...
   'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fileMenuCorAnal = uimenu(fileMenu,'Label','CorAnal','Separator','on');

% Load CorAnal callback:
%  view=loadCorAnal(view);
%  view=refreshScreen(view);
callBackstr=[view.name,'=loadCorAnal(',view.name,',1); ',...
      view.name,'=refreshScreen(',view.name,');'];
uimenu(fileMenuCorAnal,'Label','Load CorAnal','Separator','off',...
   'CallBack',callBackstr);

% Save CorAnal callback:
%  saveCorAnal(view);
callBackstr=['saveCorAnal(',view.name,'); '];
uimenu(fileMenuCorAnal,'Label','Save CorAnal','Separator','on',...
   'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fileMenuMap = uimenu(fileMenu,'Label','Parameter Map','Separator','on');

% Load Parameter Map callback:
%  view=loadParameterMap(view);
callBackstr=[view.name,'=loadParameterMap(',view.name,');'];
uimenu(fileMenuMap,'Label','Load Par Map ','Separator','off',...
   'Accelerator','j','CallBack',callBackstr);

% Save Parameter Map callback:
%  saveParameterMap(view);
callBackstr=['saveParameterMap(',view.name,');'];
uimenu(fileMenuMap,'Label','Save Par Map ','Separator','on',...
   'CallBack',callBackstr);

% Load Spatial Gradient callback:
%  view=loadSpatialGradient(view);
callBackstr=[view.name,'=loadSpatialGradient(',view.name,');'];
uimenu(fileMenuMap,'Label','Load Spatial Gradient for Inhomogeneity Correction',...
  'Separator','on','CallBack',callBackstr);
 
if strcmp(view.name(1:3), 'VOL')
  % Load laminar distance map:
  callBackstr = [view.name, '= loadLaminae(', view.name, ');'];
  uimenu(fileMenuMap, 'Label', 'Load laminar distance map',...
    'Separator', 'on', 'CallBack', callBackstr);
end

   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fileMenuROI = uimenu(fileMenu,'Label','ROI','Separator','on');

% Load ROI callback:
%  filename=getROIfilename(view);
%  view=loadROI(view,filename);
%  view=refreshScreen(view,0);
callBackstr=['filename=getROIfilename(',view.name,'); ',...
      view.name,'=loadROI(',view.name,',filename); ',...
      view.name,'=refreshScreen(',view.name,',0);'];
uimenu(fileMenuROI,'Label','Load ROI ','Separator','off',...
   'CallBack',callBackstr);

% Save ROI callback:
%  saveROI(view,view.ROIs(view.selectedROI));
callBackstr=['saveROI(',view.name,',',view.name,'.ROIs(',view.name,'.selectedROI));'];
uimenu(fileMenuROI,'Label','Save ROI ','Separator','on',...
   'CallBack',callBackstr);

% Save All ROIs callback:
%  saveAllROIs(view);
callBackstr=['saveAllROIs(',view.name,');'];
uimenu(fileMenuROI,'Label','Save All ROIs ','Separator','on',...
   'CallBack',callBackstr);
   
% Load ROI from a DB callback:
%  ROIid=getROIdbId(view); - this will probably contain a dialog
%  view=loadROIdb(view,ROIid);
%  view=refreshScreen(view,0);
callBackstr=['ROIid=getROIdbId(',view.name,'); ',...
      view.name,'=loadROIdb(',view.name,',ROIid); ',...
      view.name,'=refreshScreen(',view.name,',0);'];
uimenu(fileMenuROI,'Label','Load ROI from a DB','Separator','on',...
   'CallBack',callBackstr);


% Save ROI to database callback:
%  saveROIdb(view,view.ROIs(view.selectedROI));
callBackstr=['saveROIdb(',view.name,',',view.name,'.ROIs(',view.name,'.selectedROI));'];
uimenu(fileMenuROI,'Label','Save ROI to a DB','Separator','on',...
   'CallBack',callBackstr);


if (strcmp(view.viewType,'Gray') | strcmp(view.viewType,'Volume'))

% Load from a default location specified by a global preference
% VISTA.defaultROIDir



callBackstr=['filename=getROIfilename(',view.name,',1); ',...
      view.name,'=loadROI(',view.name,',filename,[],[],0,1); ',...
      view.name,'=refreshScreen(',view.name,',0);'];
uimenu(fileMenuROI,'Label','Load default ROI ','Separator','on',...
   'CallBack',callBackstr);

% Save the ROI to a default directory. Note that you >might< not have
% permission to do this depending on how your filesystem is set up. The
% standard ROIs are somewhat precious.
% Save ROI callback:
%  saveROI(view,view.ROIs(view.selectedROI));
callBackstr=['saveROI(',view.name,',',view.name,'.ROIs(',view.name,'.selectedROI),1);'];
uimenu(fileMenuROI,'Label','Save ROI as default','Separator','off',...
   'CallBack',callBackstr);

end % End check on viewType

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fileMenuRM = uimenu(fileMenu,'Label','Retinotopy Model','Separator','on');

% Retinotopy model callback
% It consists of two phases (a) select retinotopic file (.mat) and
% (b) select (and load) parameter into mrVista interface

% Select retinotopy model file
callBackstr=[view.name '= rmSelect(',view.name,');'];
uimenu(fileMenuRM,'Label','Select File ','Separator','off',...
       'CallBack',callBackstr);

% Load retinotopy model parameter in interface
callBackstr=[view.name '= rmLoad(',view.name,');'];
uimenu(fileMenuRM,'Label','Load Parameter ','Separator','on',...
       'CallBack',callBackstr);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Load tSeries callback:
%  scan=getCurScan(view)
%  slice=getCurSlice(view)
%  view=percentTSeries(view,scan,slice);
callBackstr=['scan=getCurScan(',view.name,'); ',...
      'slice=getCurSlice(',view.name,'); ',...
      view.name,'=percentTSeries(',view.name,',scan,slice);'];
uimenu(fileMenu,'Label','Load tSeries ','Separator','on',...
   'CallBack',callBackstr);

% Write tiff callback:
%  writeTiffImage(view);
callBackstr=['writeTiffImage(',view.name,');'];
uimenu(fileMenu,'Label','Write Tiff Image','Separator','on',...
   'CallBack',callBackstr);

% Load Alignment callback:
%   loadAlignment;
if strcmp(view.viewType,'Inplane')
    uimenu(fileMenu,'Label','Load Alignment','Separator','on',...
        'CallBack','loadAlignment');
end

% Save mrSESSION file
callBackstr=['saveSession'];
uimenu(fileMenu,'Label','Save mrSESSION','Separator','on',...
   'CallBack',callBackstr);

% (re-)create Readme.txt
callBackstr=['mrCreateReadme'];
uimenu(fileMenu,'Label','(Re-)create Readme.txt','Separator','on',...
   'CallBack',callBackstr);

%  savePrefs(view);
callBackstr=['savePrefs(',view.name,');'];
uimenu(fileMenu,'Label','Save Preferences ','Separator','on',...
   'CallBack',callBackstr);

% Login to a database callback:
%  view=loginDb(view);
% view=refreshScreen(view,0);
callBackstr=[view.name,'=loginDb(',view.name,');  ',...
    view.name,'=refreshScreen(',view.name,',0);'];
uimenu(fileMenu,'Label','Login to a database',...
   'Separator','on','CallBack',callBackstr);

if strcmp(view.viewType,'Inplane')
    % Export t-series movie
    callBackstr=['saveTSeriesMovie(',view.name,');'];
    uimenu(fileMenu,'Label','Export TSeries Movie frames...','Separator','on',...
        'CallBack',callBackstr);
end

% Quit 
% *** TODO: We should check for unsaved things, clean up child windows,
% etc.
callBackstr=['close(',num2str(view.ui.figNum),'); mrvCleanWorkspace;'];
uimenu(fileMenu,'Label','Quit ','Separator','on', 'CallBack',callBackstr);

return;

