function status = writeParfile(par,parPath);
%
% status = writeParfile(par,[parPath]);
%
% writes a .par file (used by freesurfer and Rory's
% mrVista tools using the information specified
% in the struct par.
%
% par should have at least 2 fields: 'onset', specifying
% the onset times of each trial/block, and 'cond', specifying
% number for the condition. These fields should be numeric arrays.
% They'll be the 1st and 2nd columns in the ASCII-text parfile.
%
% par may also have a 'label' field, which is a string cell; if present
% it will write the contents of each entry in the 3rd column of the
% par file.
%
% par may also have a 'color' field, in which case the color will be
% saved in a fourth column.
%
% if parPath is omitted, will prompt a dialog asking where to save.
%
% ras 06/04.
if ~exist('parPath') | isempty(parPath)
    [fname pth] = uiputfile('*.par','Name your saved parfile...');
    parPath = fullfile(pth,fname);
end

if ~isfield(par,'onset') | ~isfield(par,'cond')
    help writeParfile;
    status=-1;
    return
end

fid = fopen(parPath,'w');
for i = 1:length(par.onset)
    a = par.onset(i);
    b = par.cond(i);

    if isfield(par,'label') & length(par.label) >= i & ~isempty(par.label{i})
        c = par.label{i}; c(c==sprintf('\n')) = '';
        if isfield(par,'color') & length(par.color) >= i & ~isempty(par.color{i})
            d = num2str(par.color{i});
            fprintf(fid,'%3.2f \t %i \t%s \t%s \n', a, b, c, d);
        else
            fprintf(fid,'%3.2f \t %i \t%s \n', a, b, c);
        end
    else
        fprintf(fid,'%3.2f \t %i \n', a, b);
    end
end

status = fclose(fid);

fprintf('Wrote %s.\n',parPath);

return
