function pth = parfilesDir(view);
%
% Returns the directory containing .par
% files (specifying trial/event onsets)
% for a view. Makes it if it doesn't exist.
%
%
% ras, 05/05
global HOMEDIR;

if ~exist('view','var') | isempty(view), view = getSelectedInplane; end

if isempty(HOMEDIR), HOMEDIR = pwd; end % let's hope that's right...

% to be consistent w/ other naming conventions, I'm renaming
% my 'stim' dirs as 'Stimuli', but be back-compatible
if exist(fullfile(HOMEDIR,'stim'),'dir')
    stimDir = 'stim';
else
    stimDir = 'Stimuli'; % this will be the new default
end
    
pth = fullfile(HOMEDIR,stimDir,'parfiles'); 

% make sure it exists
ensureDirExists(pth);

return

