function view = eventMenu(view, parent);
% view = eventMenu(view, <parent=gcf>);
% 
% Adds a menu to the current view figure which containing callbacks to
% launch event-related analyses. Attaches to the parent object, which is
% the view's figure if one isn't added (may start attaching to analysis or
% other menu).
%
% These analyses currently include:
%
%   Assign parfiles to scans: associate particular scans with paradigm
%   files (.par). Parfiles are looked for in the session's stim/parfiles/
%   subdir, and are text tab-delimited files with two columns: onset times
%   of each trial, and a condition number for each trial. Multiple scans
%   can be assigned to multiple parfiles with this interface, though it
%   maps each selected parfile to each selected scan in order from 1st to
%   last. Parfiles need to be assigned to do further analyses for a scan
%   (see er_assignParfilesToScans)
%
%
%   Deconvolve: Deconvolve time courses from rapid event-related scans,
%   creating a new scan in averages. This new scan contains time courses
%   for each voxel of the following format: average trial for cond 1,
%   variances for each time point for cond 1 avg trial, average trial for
%   cond 2, variances for each time point for cond 2 avg trial, etc.
%   Currently the settings are to deconvolve a 22-second time window for
%   each trial, the first 4 secs of which occur before trial onset. 
%   (see er_selxavg)
%
%   Appy GLM: apply a GLM to the selected scans. This is the first
%   step in computing contrast maps below, if you select compute
%   contrast map and it doesn't find GLM files, it runs one automatically.
%
%   Compute Contrast Map: Create a parameter map representing 
%   a statistic comparing two conditions from the current scan. Note there
%   are two steps here. First it needs to fit a GLM (er_selxavg), which can%   take 5-10 minutes, depending on the number of scans and their size;%   then it needs to compare the values obtained from the first step and%   compute the selected contrast. The first step needs to be done only%   once; the code detects if this has been done already and, if it hasn't,%   runs it. 
%       The default statistic for contrast maps is -log10(p) of a t-test between
%   the selected conditions. Saves param maps in the view's dataDir, named
%   'contrastMap_[name].mat'. Also saves a file%   'contrastMap_[name]_ces.mat', which contains the contrast effect size%   in (something very like) % signal.%   (see computeContrastMap, er_mkcontrast(interface))
%
%   'New' GLM tools: A re-implementation of the same algorithms in Apply
%   GLM / Compute Contrast Map (but a little nicer and tailored to mrVista
%   processing params).
%
%   Time Course UI: Plot time courses from selected scan or scans, taking
%   into account condition data from the parfiles, for the selected ROI. If
%   multiple scans are selected, it concatenates them after applying the
%   currently selected detrend options. Allows various options for plotting
%   the data, including whole time course, all trials, mean trials, mean
%   amplitudes, relative fMRI amplitudes, and more.
%   (see timeCourseUI)
%
%   MultiVoxel UI: interface for analyzing data across voxels in the
%   current ROI. Contains many custom analysis tools. Can be used to 
%   run Haxby-style pattern analyses, and compute selectivity maps.
%   (see multiVoxelUI)
%
% ras 03/10/04.
if notDefined('parent'), parent = view.ui.windowHandle;  end

mrGlobals;

eventMenu = uimenu(parent, 'Label','Event-Related','Separator','on');

% Edit Event-Related Parameters callback:
%   params = er_getParams(view);
%   params = er_editParams(params);
%   er_setParams(view, params);
cb = [sprintf('params = er_getParams(%s); ', view.name) ...
      sprintf('[scans dt] = er_getScanGroup(%s); ', view.name) ...
      'params = er_editParams(params, dataTYPES(dt).name, scans); ' ...
      sprintf('er_setParams(%s, params); ', view.name)];
uimenu(eventMenu, 'Label', 'Edit Event-Related Parameters (cur scan)', ...
    'Separator', 'off', 'Callback', cb);
 
% Assign parfiles callback:
%   view=er_assignParfilesToScans(view);
%   view=refreshScreen(view);
cb = ['er_assignParfilesToScans(',view.name,'); '...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(eventMenu, 'Label', 'Assign parfiles to scans', ...
    'Separator', 'off', 'Callback', cb);

% Show current parfiles callback:
%  er_displayParfiles(view);
cb = sprintf('er_displayParfiles(%s); ,', view.name);
uimenu(eventMenu, 'Label', 'Show parfiles / scan group', ...
        'Separator', 'off', 'Callback', cb);

% group scans submenu
groupMenu = uimenu(eventMenu,'Label','Grouping...','Separator','on');

% group scans callback:
%  er_groupScans(view,[],2);
cb=['er_groupScans(' view.name ',[],2);'];
uimenu(groupMenu,'Label','Group Scans','Separator','on',...
    'Callback',cb);

% assign group to cur scan callback:
%  er_groupScans(view);
cb=['er_groupScans(' view.name ',[],1);'];
uimenu(groupMenu,'Label','Assign Group to Current Scan','Separator','on',...
    'Callback',cb);

% % preprocess scans submenu
% (Disabled by ras, 06/06 -- do people still use this?
% I tend not too anymore, but can turn it back on)
%
% preprocessMenu = uimenu(eventMenu,'Label','Preprocess...','Separator','on');
% % preprocess selected scans callback:
% %  concatenateScans(view);
% cb = sprintf('concatenateScans(%s)',view.name);
% uimenu(preprocessMenu,'Label','Preprocess (Select Scans)','Separator','on',...    
%     'CallBack',cb);
% 
% % preprocess scan group callback:
% %  concatenateScans(view,er_getScanGroup(view));
% % cb = sprintf('concatenateScans(%s,er_getScanGroup(%s))',view.name,view.name);uimenu(preprocessMenu,'Label','Preprocess (Scan Group)','Separator','on',...    'CallBack',cb);
% 
% % cache tSeries callback:
% %  view = cacheTSeries(view);
% cb = sprintf('%s = cacheTSeries(%s);',view.name,view.name);
% uimenu(preprocessMenu,'Label','Cache tSeries','Separator','on',...
%     'CallBack',cb);

% Deconvolve callback:
%   er_deconvolve(view);
%   view=refreshScreen(view);
cb=['er_deconvolve(',view.name,'); '...   
        view.name,'=refreshScreen(',view.name,');'];
uimenu(eventMenu,'Label', 'Deconvolve', 'Separator', 'on', 'Callback',cb);

% GLM submenu:
glmMenu = uimenu(eventMenu,'Label','Apply GLM (Old Version)...','Separator','on');

% apply GLM (current scan) callback:
%   er_runSelxavgBlock(view);
%   view=refreshScreen(view);
cb=['er_runSelxavgBlock(',view.name,'); '...    
        view.name,'=refreshScreen(',view.name,');'];
uimenu(glmMenu,'Label','Current Scan','Separator','on',...    
    'CallBack',cb);

% apply GLM (block-design) callback:
%   er_runSelxavgBlock(view,0);
%   view=refreshScreen(view);
cb=['er_runSelxavgBlock(',view.name,',0,1); '...    
        view.name,'=refreshScreen(',view.name,');'];
uimenu(glmMenu,'Label','Select Scans','Separator','on',...    
    'CallBack',cb);

% apply GLM (scan group) callback:
%   er_runSelxavgBlock(view,-1);
%   view=refreshScreen(view);
cb=['er_runSelxavgBlock(',view.name,',-1,1); '...    
        view.name,'=refreshScreen(',view.name,');'];
uimenu(glmMenu,'Label','Scan Group','Separator','on',...    
    'CallBack',cb);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% contrast map submenu       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
contrastMenu = uimenu(eventMenu,'Label','Contrast Map (Old Code)...','Separator','on');

% contrast map (current scan) callback:
% view = er_mkcontrast(view,0);
cb = sprintf('%s = er_mkcontrast(%s,0);',view.name,view.name);
uimenu(contrastMenu,'Label','Contrast Map (Current Scan)','Separator','on',...    
    'CallBack',cb);

% contrast map (select scans) callback:
% view = er_mkcontrast(view);
cb = sprintf('%s = er_mkcontrast(%s);',view.name,view.name);
uimenu(contrastMenu,'Label','Contrast Map (Select Scans)','Separator','on',...    
    'CallBack',cb);
% contrast map (scan group) callback:
% view = er_mkcontrast(view,-1);
cb = sprintf('%s = er_mkcontrast(%s,-1);',view.name,view.name);
uimenu(contrastMenu,'Label','Contrast Map (Scan Group)','Separator','on',...    
    'Accelerator','5','CallBack',cb);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% New Code GLM/Contrast submenu       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
newGLMMenu = uimenu(eventMenu,'Label','GLM/Contrast, New Code (Beta)...',...
            'Separator','on');

% apply GLM (new code) cur scan callback:
% applyGlm(view,getCurScan(view));
cb = sprintf('applyGlm(%s,getCurScan(%s));',view.name,view.name);
uimenu(newGLMMenu,'Label','Apply GLM, cur scan','Separator','off',...
       'Callback',cb);

% apply GLM (new code) select scans callback:
% applyGlm(view,er_selectScans(view));
cb = sprintf('applyGlm(%s,er_selectScans(%s));',view.name,view.name);
uimenu(newGLMMenu,'Label','Apply GLM, select scans','Separator','off',...
       'Callback',cb);

% apply GLM (new code) scan group callback:
% applyGlm(view,er_getScanGroup(view));
cb = sprintf('applyGlm(%s,er_getScanGroup(%s));',view.name,view.name);
uimenu(newGLMMenu,'Label','Apply GLM, scan group','Separator','off',...
       'Callback',cb);

% Compute Contrast Map (new code) callback:
% computeContrastMap2(view);
cb = sprintf('computeContrastMap2(%s);',view.name);
uimenu(newGLMMenu,'Label','Compute Contrast Map','Separator','on',...
       'Callback',cb);
   
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% time course UI submenu:    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tcMenu = uimenu(eventMenu,'Label','Time Course UI','Separator','on');
% time course UI callback (current scan):
%  timeCourseUI(view);
cb = sprintf('timeCourseUI(%s,[],getCurScan(%s));',view.name,view.name);
uimenu(tcMenu,'Label','Current Scan','Separator','on',...    
    'Accelerator','T','CallBack',cb);

% time course UI callback (multiple scans):
%  tc_plotScans(view);
cb=['tc_plotScans(' view.name ');'];
uimenu(tcMenu,'Label','Select Scans','Separator','on',...    
    'Accelerator','6','CallBack',cb);

% time course UI callback (scan group):
%  tc_plotScans(view,1);
cb=['tc_plotScans(' view.name ',1);'];
uimenu(tcMenu,'Label','Scan Group','Separator','on',...    
    'Accelerator','G','CallBack',cb);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% multi voxel UI submenu:   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mvMenu = uimenu(eventMenu,'Label','Multi Voxel UI','Separator','on');

% multi voxel UI callback:%  timeCourseUI(view);
cb=['timeCourseUI(' view.name ');'];
uimenu(mvMenu,'Label','Current Scan','Separator','on','CallBack',cb);

% multi voxel UI callback (multiple scans):
%  tc_plotScans(view);
cb=['mv_plotScans(' view.name ');'];
uimenu(mvMenu,'Label','Select Scans','Separator','on','CallBack',cb);

% multi voxel UI callback (scan group):
%  tc_plotScans(view,1);
cb=['mv_plotScans(' view.name ',1);'];
uimenu(mvMenu,'Label','Scan Group','Separator','on','CallBack',cb);


return
