function roi = tc_roiStruct(view,roi);
% 
% roi = tc_roiStruct(view,roi);
%
% A tool for parsing arguments specifying ROIs.
%
% Problem: you may want to specify ROIs in many
% ways: by giving the name of a mrVista ROI struct,
% or the index, or the whole structure, or giving
% arbitrary roi coordinates. This happens several
% times in my code.
%
% Solution: be flexible about specification; infer
% how the roi is passed by its class and size.
%
% This has come up a couple of times in my 
% code, so I thought I'd dedicate a function
% to parse this roi argument. This always
% returns a mrVista ROI structure, with 
% color, coords, name, and viewType fields.
%
% ras, 04/05.
% ras, 06/05: now if roi is a cell w/ many ROI 
% designations, will return a struct array.

if iscell(roi)
    % get many ROI structs, recursively
    for i = 1:length(roi)
        tmp(i) = tc_roiStruct(roi{i});
    end
    roi = tmp;
    return
end
    
if ischar(roi)  
    % assume name of ROI
    r = findROI(view,roi);
    roi = view.ROIs(r);
elseif isnumeric(roi)
    if length(roi)==1
        % index into view's ROIs 
        roi = view.ROIs(roi);
    elseif size(roi,1)==3
        % assume specifying 3xN ROI coords; build an roi struct
        coords = roi;
        roi = struct('color','coords','name','viewType');
        roi.color = 'b';
        roi.coords = coords;
        if size(roi,2)==1
            roi.name = sprintf('Point %i, %i, %i',coords(1),coords(2),coords(3));
        else
            roi.name = '(Multiple selected points)';
        end
        roi.viewType = viewGet(view,'viewType');
    end
end


return