function tc_plotWholeTc(tc, parent);
% tc_plotWholeTc(tc, <parent=tc.ui.plot panel>);
%
% timeCourseUI (mrLoadRet):
% plots the mean time course across the entire selected scans,
% designating different condition periods / half-cylces with different
% colors. Everything's specified in the tc struct.
%
% 02/23/04 ras: broken off as a separate function (previously kept in
% ras_tc).
% 03/06 ras: integrated uipnanel changes.
if nargin<1,    tc = get(gcf,'UserData');     end
if nargin<2,    parent = tc.ui.plot;          end
if parent==gcf | parent==get(gcf, 'CurrentAxes')
    % make a uipanel to fit on the target
    parent = uipanel('Parent', parent, ...
                     'Units', 'normalized', ...
                     'BackgroundColor', get(gcf, 'Color'), ...
                     'Position', [0 0 1 1])
end

axes('Parent', parent);
plot(tc.wholeTc); % just to get axis bounds
AX = axis;
cla;
hold on
condNums = unique(tc.trials.cond);

% shift onsets by a specified delta, if it exists 
% (this is useful e.g. if the n discarded frames is incorrectly
% specified, or to compensate for h.r.f. rise time)
if isfield(tc.params,'onsetDelta') & tc.params.onsetDelta ~= 0
    tc.trials.onsetSecs = tc.trials.onsetSecs + tc.params.onsetDelta;
end

% trial boundaries
tx = [tc.trials.onsetSecs length(tc.wholeTc)*tc.TR]; 

% make patches for the different trial conditions
for i = 1:length(tx)-1
    t1 = tx(i);
    t2 = tx(i+1);
    X = [t1 t1 t2 t2];
    Y = [AX(3) AX(4) AX(4) AX(3)];
    cond = tc.trials.cond(i);
    ind = find(condNums==cond);
    C = tc.trials.condColors{ind};
    if isunix
        patch(X,Y,C);
    else
        patch(X,Y,C); %,'EdgeAlpha',0);
        if length(tc.trials.condNames)==1
            patch(X,Y,C,'EdgeAlpha',1);
        end    
    end
end

% plot the time course over the patches
t = [1:length(tc.wholeTc)] .* tc.TR;
plot(t,tc.wholeTc,'LineWidth',2,'color',[1 1 1]); 
ylabel('% Signal');
xlabel('Time, secs');

% for longer time courses, may want a UI control
scale = 200;  % max seconds to nicely plot TC
if max(t) > scale
    % shrink the axes a little for the control
    oldPos = get(gca,'Position');
    newPos = [oldPos(1) oldPos(2)+.08 oldPos(3) oldPos(4)-.08];
    set(gca,'Position',newPos);
    
	% set the axes to have a nice aspect ratio
    newAX = [1 scale AX(3) AX(4)];
    axis(newAX);
    
    % add a slider to move back and forth 
    cbstr = 'val=get(gcbo,''Value'');';
%     cbstr = sprintf('%s \n axis(get(gcbo,''UserData''));',cbstr);
    cbstr = sprintf('%s \n axis([val val+%i %f %f]);',...
                    cbstr,scale,AX(3),AX(4));
    sliderPos = [oldPos(1) .02 oldPos(3) .05];
    if tc.params.legend, sliderPos = sliderPos + [-.03 0 -.2 0]; end    
    h = uicontrol('Style', 'slider',  'UserData', gca, ...
                  'Units', 'Normalized', 'Position', sliderPos, ...
                  'Min', 0, 'Max', max(t)-scale, ...
                  'Callback', cbstr,'BackgroundColor','w');
    zoomPos = [oldPos(1)-.1 .02 .08 .05];
    if tc.params.legend, zoomPos = zoomPos + [-.01 0 -.02 0]; end    
    uicontrol('Style', 'pushbutton', 'Units','Normalized',...
              'Position', zoomPos, ...
              'BackgroundColor', 'w', 'String', 'Whole Tc',...
              'Callback', 'axis auto');
end



return

