function tc_meanAmpsPlusTcs(tc);
% tc_meanAmpsPlusTcs(tc);
%
% Provide a quick summary of ROI response
% to different conditions, by plotting both
% the mean time courses and mean amplitudes
% to each condition. Combines the
% routines from tc_plotMeanTrials and 
% tc_barMeanAmplitudes.
%
%
% ras 03/05.

% delete existing large legend
otherAxes = findobj('Parent', gcf, 'Type', 'axes');
delete(otherAxes);

%%%%%%%%%%%%%%%%%%%
% mean amplitudes %
%%%%%%%%%%%%%%%%%%%
axes('Parent', tc.ui.plot, 'Position',[.1 .2 .35 .6]);
hold on

h1 = gca;

lineWidth = 2;
selconds = find(tc_selectedConds(tc));
nConds = length(selconds);
labels = {};

for i = 1:nConds
    cond = selconds(i);
    labels{end+1} = tc.trials.condNames{cond};
    
    nTrials = max(2, sum(~isnan(tc.amps(:,cond))));
    
    Y = nanmean(tc.amps(:,cond));
    E = nanstd(tc.amps(:,cond)) ./ sqrt(nTrials-1);
    starbar(Y,E,tc.Hs(cond),'X',i,'color',tc.trials.condColors{cond});
end

grid on

% set line width
htmp = findobj('Type','line','Parent',gca);
set(htmp,'LineWidth',lineWidth);

% add labels
set(gca,'XTick',[1:nConds]);
if tc.params.legend==0, set(gca, 'XTickLabel', labels); end
xlabel('Condition', 'FontWeight', 'bold', 'FontAngle', 'italic');
ylabel('Mean Amplitude, % Signal', 'FontWeight', 'bold', 'FontAngle', 'italic');

% set axes to frame bars nicely
axis auto;
AX = axis;
AX(1:2) = [0 nConds+1];
if isfield(tc.params,'axisBounds') & ~isempty(tc.params.axisBounds)
    AX(3:4) = tc.params.axisBounds(3:4);
end
axis(AX);

%%%%%%%%%%%%%%%%%%%%%
% mean time courses %
%%%%%%%%%%%%%%%%%%%%%
h2 = axes('Parent', tc.ui.plot, 'Position', [.55 .2 .4 .6]);
tc_plotMeanTrials(tc, h2, 2);
% hold on
% 
% for i = find(tc_selectedConds(tc))
%     hold on
%     cond = tc.trials.condNums(i);
%     col = tc.trials.condColors{i};
%     htmp = errorbar(tc.params.timeWindow, tc.meanTcs(:,i), tc.sems(:,i));
%     set(htmp, 'Color', col, 'LineWidth', 2);
% end
% 
%     
% % % obscure the lower ticks (Tufte style presentation)
% % xtick = get(gca, 'Xtick'); xticklabel = get(gca, 'XTickLabel');
% % set(gca, 'XTick', xtick(2:end)); %, 'XTickLabel', xticklabel(2:end,:));
% % ytick = get(gca, 'Ytick'); yticklabel = get(gca, 'YTickLabel');
% % set(gca, 'YTick', ytick(2:end)); %, 'YTickLabel', yticklabel(2:end,:));
% % line([xtick(1) xtick(2)], [ytick(1) ytick(1)], 'Color', 'w', 'LineWidth', 2);
% % line([xtick(1) xtick(1)], [ytick(1) ytick(2)], 'Color', 'w', 'LineWidth', 2);
% 
% grid on
% 
% % indicate the peak and baseline periods, if selected
% if tc.params.showPkBsl==1
%     AX = axis;
% 	plot(tc.bslPeriod,repmat(AX(3),size(tc.bslPeriod)),...
%         'k','LineWidth',3.5);
% 	plot(tc.peakPeriod,repmat(AX(4),size(tc.peakPeriod)),...
%         'r','LineWidth',3.5);	
% end
% 
% if isfield(tc.params,'axisBounds') & ~isempty(tc.params.axisBounds)
%     axis(h2,tc.params.axisBounds); 
% end
% 
% xlabel('Trial time, secs', 'FontWeight', 'bold', 'FontAngle', 'italic');
% ylabel('% Signal', 'FontWeight', 'bold', 'FontAngle', 'italic');


return

