function tc = tc_legend(tc);
%
% tc = tc_legend(tc);
%
% Populate the legend uipanel of a Time Course UI with the
% current set of selected condition names and colors.
%
% ras, 03/06
if nargin==0, tc = get(gcf, 'UserData'); end

if ~checkfields(tc, 'ui', 'legend')
    warning('No GUI found for this time course struct.')
    return
end

% clear any existing objects in the panel
old = findobj('Parent', tc.ui.legend);
delete(old);

% get selected conditions
sel = find(tc_selectedConds(tc));
N = length(sel);

% the legend images will be an array of subplots, with at
% most 20 rows per column:
ncols = ceil(N/20);
nrows = min(20, N);

% for each selected condition, make a patch with 
% that condition's color, and the condition name
for i = sel
    j = find(sel==i); 
    row = mod(j-1, 20) + 1;
    col = ceil(j/20);
    pos = [.8*(col-1)/ncols,  .96-row*.05,  .1,  .02];
    axes('Position', pos, 'Parent', tc.ui.legend);
    axis([0 1 0 1]); axis off; 
    set(gca, 'Box', 'off');
    hp = patch([0 1 1 0], [0 0 1 1], tc.trials.condColors{i});
    set(hp, 'EdgeColor', 'none');
    text(1.5, 1.3, tc.trials.condNames{i}, 'FontSize', 12, ...
         'HorizontalAlignment', 'left', 'VerticalAlignment', 'top');
end

% return focus to the main plot panel
axes('Parent', tc.ui.plot);

return
