function tc = tc_applyGlm(tc);
%
% tc = tc_applyGlm(tc):
%
% Apply a general linear model to the current time course,
% and append the resulting glm struct to the tc struct.
%
% ras, 04/05.
if notDefined('tc')
    tc = get(gcf,'UserData');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get Data Matrix Y
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y = tc.wholeTc(:);

%%%%% replicate what I did in er_selxavg: 
% artificially add offset equal to raw tSeries mean,
% so that PSC estimate is accurate
off_est = nanmean(Y); % offset estimate
HPFPeriod = round(60/tc.params.framePeriod);
Y = removeBaseline2(Y, HPFPeriod);
Y = Y + off_est;

% account for onset delta -- it's easier to implement 
% this here than in glm_createDesMtx, though it may
% be wiser to do that down the line:
if tc.params.onsetDelta ~= 0
    Y = circshift(Y, round(tc.params.onsetDelta/tc.params.framePeriod));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get Predictors Matrix X 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[X, nh, hrf] = glm_createDesMtx(tc.trials, tc.params, Y, 0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Apply the GLM
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tc.glm = glm(Y,X,tc.TR,nh);
tc.glm.hrf = hrf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% add to fig's user data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isfield(tc,'ui')
    set(gcf,'UserData',tc);
end


return
