function [model, params] = loadGlmSlice(view,slice,scan);
%
% [model, params] = loadGlmSlice(view,[slice,scan]);
% 
% Load the results of a General Linear Model applied to
% mrVista data. Returns an analysis model and the event-related
% parameters used in the model.
%
% The format of the saved file may vary depending
% on how we decide to minimize the footprint of each
% analysis (omitting some fields of the analysis
% which can be easily recomputed on the fly, and 
% maybe changing data types), but in general they'll
% be saved in the following place:
% 
% [sessionDir]/[viewType]/[dtName]/Scan[#]/glmSlice[#].mat
% 
% E.g.:
% 020405ras/Inplane/GLMs/Scan1/glmSlice1.mat
%
%
% ras 06/06.
if ~exist('slice','var') | isempty(slice)
    slice = viewGet(view,'curSlice');
end

if ~exist('scan','var') | isempty(scan)
    scan = viewGet(view,'curScan');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get path for saved data %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
loadPath = fullfile(dataDir(view),['Scan' num2str(scan)],...
                             ['glmSlice' num2str(slice) '.mat']);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load model, account for rescaling done to save space   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load(loadPath,'model','rng');
fields = fieldnames(rng);
for i = 1:length(fields)
    % we store many double values as int16: rescale each
    % one back to double format, with the appropriate range
    model.(fields{i}) = rescale2(model.(fields{i}),[],rng.(fields{i}));
end

% we also can recompute the SEMs quickly on-the-fly, given
% the std deviations and degrees-of-freedom:
tmp = repmat(model.trial_count(:)',[model.nh 1 size(model.betas,3)]);
model.sems = model.stdevs ./ sqrt(tmp);

if nargout>1
    mrGlobals;
    params = dataTYPES(viewGet(view,'curdt')).eventAnalysisParams(scan);
end

return