function model = applyGlmSlice(view,slice,scans,params);
%
% model = applyGlmSlice(view,[slice],[scans],[params]);
% 
% Apply a General Linear Model to the time series
% for one slice of a view, using the specified
% event-related analysis parameters.
% 
% Returns a model struct with results of the GLM.
%
% ras, 04/18/05.
if ieNotDefined('view')
    view = getSelectedInplane;
    if isempty(view)
        help(mfilename);
        return
    end
end

if ~exist('slice','var') | isempty(slice)
    slice = viewGet(view,'curSlice');
end

if ~exist('scans','var') | isempty(scans)    
    [scans dt] = er_getScanGroup(view);     
    view = selectDataType(view,dt);
end

if ~exist('params','var') | isempty(params)
    params = er_getParams(view,scans(1));
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Grab useful parameters for easy access
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tr = params.framePeriod;
trials = er_concatParfiles(view,scans);
nConds = sum(trials.condNums>0);
nScans = length(scans);
for s = 1:nScans
	framesPerRun(s) = numFrames(view,scans(s));
end
nFrames = max(framesPerRun);
% get # voxels as # in current slice,
% which depends on the view type
switch view.viewType
    case 'Inplane', nVoxels = prod(sliceDims(view));
    case 'Gray', nVoxels = size(view.coords,2);
    case 'Flat', nVoxels = size(view.coords{slice},2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get Data Matrix Y
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize Y matrix
Y = []; %repmat(NaN,[nFrames nVoxels nScans]);

% load tSeries from selected slice
hwait = waitbar(0,'Loading tSeries...');
for s = 1:nScans
%     view = percentTSeries(view,scans(s),slice);
%     tmp = view.tSeries;

    % 05/05 ras: this code
    % mimics what er_selxavg does:
    tmp = loadtSeries(view,scans(s),slice);
    off_est = repmat(mean(tmp),[size(tmp,1) 1]);
    tmp = removeBaseline2(tmp,60/tr) + off_est;
    
    Y = [Y; tmp];
    waitbar(s/nScans,hwait);
end
close(hwait);

% this may cause a memory problem for huge #s of voxels,
% but it's regrettably necessary:
Y = double(Y);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get Predictors Matrix X 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[X, nh, hrf] = glm_createDesMtx(trials,params,Y);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Apply the GLM
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model = glm(Y,X,tr,nh);

model.hrf = hrf;

% Note where the data came from in the glm result:
model.roiName = sprintf('Slice %i',slice);


return
