function view = thresholdAnatMap(view,thresh);
% view = thresholdAnatMap(view,[thresh]);
%
% makes the part of the color map that deals with the anatomical 
% image a thresholded gray scale, to see sulci and gyri more clearly. 
% Sets these values for all modes (but doesn't touch the overlay color
% maps).
%
% This is what the current curvature map in mrMesh looks like, and it's
% particularly useful to do this on flat maps, to map between the inflated
% brain and the flat map. 
%
% The optional 'thresh' argument is the minimum gray value for (brighter colored)
% gyri (as opposed to darker sulci); it defaults to 0.5. 
%
% written 01/27/04 ras.
if ieNotDefined('view'), mrGlobals; view=getSelectedFlat; end
if ieNotDefined('thresh'), thresh = 0.5;   end

lightRng = [0.6 0.8];
darkRng = [0.3 0.5];

cmap = gray(view.ui.anatMode.numGrays);
cmap(cmap < thresh) = normalize(cmap(cmap < thresh),darkRng(1),darkRng(2));
cmap(cmap >= thresh) = normalize(cmap(cmap >= thresh),lightRng(1),lightRng(2));

% nLevels = size(cmap,1);
nLevels = view.ui.ampMode.numGrays;

% assign to all the display modes -- here
% I'm assuming the colormaps for all view modes
% have the same number of grayscale anat levels. 
% (This seems to be correct...):
view.ui.anatMode.cmap(1:nLevels,:) = cmap;
view.ui.ampMode.cmap(1:nLevels,:) = cmap;
view.ui.coMode.cmap(1:nLevels,:) = cmap;
view.ui.phMode.cmap(1:nLevels,:) = cmap;
view.ui.mapMode.cmap(1:nLevels,:) = cmap;


% the thresholded cmap works best with an anat clip of [0 1]
setAnatClip(view,[0 1]);

refreshScreen(view);

return