function pathStr=rmSave(view,model,params,forceSave);       
% rmSave - save/reshape model analysis in output that mrVISTA can read
% 
% output = rmSave(view,model,forceSave);
% 
% 12/2006 SOD: wrote it.

%save

% inputif ieNotDefined('view'),  error('Need view structure');  end;
if ieNotDefined('model'), error('Need model structure'); end;
if ieNotDefined('params'), error('Need params structure'); end;
if ieNotDefined('forceSave'), forceSave = 0;             end;

% reshape all params in model struct
dims     = viewGet(view,'datasize');

% if roi get coords
% also compute dimSize, dimSize is the size a parameters has to be
% if we want to reshape it. If it is not this size it is probably
% not defined for each voxel (eg df or description).

% if roi
coords = rmGet(model{1},'coords');
if ~isempty(coords),
  switch lower(viewGet(view,'viewType')),
    case {'inplane'}
      rsFactor = upSampleFactor(view,1);
      if length(rsFactor)==1
        coords(1:2,:) = round(coords(1:2,:)/rsFactor(1));
      else
        coords(1,:) = round(coords(1,:)/rsFactor(1));
        coords(2,:) = round(coords(2,:)/rsFactor(2));
      end;
      coords = unique(coords','rows')';
      
    case {'gray'}
      coordsInd    = zeros(1,size(coords,2));
      allcoords    = viewGet(view,'coords');
      % loop because intersect orders the output
      for n=1:size(coords,2);
        [tmp, coordsInd(n)] = intersectCols(allcoords,coords(:,n));
      end;
      
    otherwise
      error(sprintf('[%s]:unknown viewType %s',...
        mfilename,viewGet(view,'viewType')));
  end;
  dimSize = size(coords,2);
else,
  dimSize = prod(dims);
end;

% if param is dimSize we have to reshape if   
% we do this for the following parameters
fnames = {'x','y','sigmamajor','sigmaminor','sigmatheta',...
          'sigma2major','sigma2minor','sigma2theta',...
          'b',...
          'tf','trm','tall','trmf',...
          'rss'};
for m = 1:length(model),
  for f = 1:length(fnames),
    param = rmGet(model{m},fnames{f});
    if prod(size(param)) > 1 & isnumeric(param),

      switch lower(viewGet(view,'viewType')),
       case {'inplane'}
        % if beta then all components are stored in 4th dimension
        switch lower(fnames{f})
         case 'b', 
          % could do in one step but I'm concerned about the
          % ordering
          for ii = 1:size(param,3),
            newparam(:,:,:,ii) = myreshape(param(:,:,ii),dims,coords);
          end;
          param = newparam;
         otherwise,          
          param = myreshape(param,dims,coords);
        end
       
       case {'gray'}
        switch lower(fnames{f})
         case 'b',
          out                = zeros(1,size(allcoords,2),size(param,3));
          out(1,coordsInd,:) = param;
          param              = out;
         otherwise
          out            = zeros(1,size(allcoords,2));
          out(coordsInd) = param;
          param          = out;
        end;
        
        otherwise
         error(sprintf('[%s]:unknown viewType %s',...
            mfilename,viewGet(view,'viewType')));
      end;  
      model{m} = rmSet(model{m},fnames{f},param);
    end;
  end;
end;

% file name
outputname = ['retModel-',datestr(now,'yyyymmdd'),'.mat'];;
pathStr    = fullfile(dataDir(view),outputname); 

% overwrite?
if exist(pathStr,'file') & forceSave == 0,
  [f,p] = uiputfile('*.mat','File exists, please select file?', ...
                    pathStr);
  % check
  if(isequal(f,0)||isequal(p,0))
    fprintf(1,'[%s]:Model not saved.\n',mfilename);
    return;
  else
    pathStr = fullfile(p,f);
  end;
end;

% save
save(pathStr,'model','params');
fprintf(1,'[%s]:Saved %s.\n',mfilename,pathStr);  
return;
%------------------------

%------------------------
function mapdata = myreshape(param,dims,coords)
if isempty(coords),
  % otherwise
  mapdata = reshape(param.',dims);
else,  
  mapdata = zeros(dims);
  for n=1:length(param),
    mapdata(coords(1,n),coords(2,n),coords(3,n)) = param(n);
  end;
end;
return;
%------------------------
