function params = rmMakeStimulus(params);
% rmMakeStimulus - make stimulus sequence 
%
% stim = rmMakeStimulus(params);
%
% This program makes the stimulus sequence for each stimulus.
% This will be used to predict the response profiles of certain
% receptive fields: response = RF.*stim (rmFit)
%
%
% 12/2005 SOD: wrote it.

% TODO:  Would be kind of cool to use the actual stimulus program when
% possible.

%-------------------
%--- allow different stimuli
%-------------------
switch params.stimulusType,
 case 'wedge/ring',
  params = makeWedgeRing(params);
  
 case 'wedge/ring on/off',
  params = makeWedgeRingOnOff(params);
 
 otherwise,
  disp(sprintf('[%s]:Unknown stimulus type: %s.',...
               mfilename,params.stimulusType));
  return;
end;


%-------------------
% in order to speed things up we need to limit the representation
% of the stimulus (square matrix) to those points that fall within
% the stimulus window (non square - mostly circular). For a circle
% stimulus this will be about 25%.
% This will be done for (a) the stimulus, (b) the grid used to make
% the RFs.
%-------------------

% calculate wich points are in the stimulus window
params.stim(1).stimwindow = zeros(size(params.stim(1).images(:,1)));
for n=1:length(params.stim),
  params.stim(1).stimwindow =  params.stim(1).stimwindow + ...
      sum(params.stim(n).images,2);
end;
params.stim(1).stimwindow = params.stim(1).stimwindow > 0;
params.stim(1).stimwindow = params.stim(1).stimwindow(:);
params.stim(1).instimwindow = find(params.stim(1).stimwindow==1);

% now only keep points withing stimulus window
keep = params.stim(1).instimwindow;
for n=1:length(params.stim),
  params.stim(n).images   = params.stim(n).images(keep,:);
end;

% we do the same for x,y coordinates
params.analysis.X = params.analysis.X(:);
params.analysis.X = params.analysis.X(keep);
params.analysis.Y = params.analysis.Y(:);
params.analysis.Y = params.analysis.Y(keep);

return;

%-------------------
%---  now actually make them
%-------------------

%--- regular retinotopic stimulus
function params = makeWedgeRing(params);
% largely copied from makeRetinotopyStimulus

% Loop that creates the final images
fprintf('[%s]:Creating images:',mfilename);
for n = 1:2,
  type       = params.stim(n).type;
  outerRad   = params.stim(n).stimSize;
  innerRad   = 0;
  wedgeWidth = params.stim(1).stimWidth .* (pi/180);
  ringWidth  = outerRad .* params.stim(1).stimWidth ./ 360;
  numImages  = params.stim(n).nFrames ./ params.stim(n).nCycles;
  x          = params.analysis.X;
  y          = params.analysis.Y;
  r          = sqrt (x.^2  + y.^2);
  theta      = atan2 (y, x);	% atan2 returns values between -pi and pi
  theta      = mod(theta,2*pi);	% correct range to be between 0 and 2*pi
  
%  images     = zeros(size(x,2),size(x,1),numImages);
  images     = zeros(prod([size(x,2) size(x,1)]),numImages);
  for imgNum=1:numImages
    img        = zeros(size(x,2),size(x,1));
    switch type;
     case 'wedge',
      loAngle = 2*pi*((imgNum-1)/numImages);
      hiAngle = loAngle + wedgeWidth;
      loEcc   = innerRad;
      hiEcc   = outerRad;
     case 'ring',
      loAngle = 0;
      hiAngle = 2*pi;
      loEcc   = outerRad * (imgNum-1)/numImages;
      hiEcc   = loEcc+ringWidth;
     otherwise,
      error('Unknown stimulus type!');
    end
    window = ( ((theta>=loAngle & theta<hiAngle) | ...
                (hiAngle>2*pi & theta<mod(hiAngle,2*pi))) & ...
               ((r>=loEcc & r<=hiEcc)) & ...
               r<outerRad);
    
    img(window) = 1;
%    images(:,:,imgNum) = img;
    images(:,imgNum) = img(:);
    fprintf('.');drawnow;
  end;
%  img    = repmat(images,[1 1 params.stim(n).nCycles]);
%  preimg = img(:,:,1+end-params.stim(n).prescanDuration:end);
%  params.stim(n).images = cat(3,preimg,img);
  img    = repmat(images,[1 params.stim(n).nCycles]);
  preimg = img(:,1+end-params.stim(n).prescanDuration:end);
  params.stim(n).images = cat(2,preimg,img);
end;
fprintf('Done.\n');drawnow;

return;

%--------------------------------------
%--- retinotopic mapping with blanks
%--------------------------------------
function params = makeWedgeRingOnOff(params);
% largely copied from makeRetinotopyStimulus

% Loop that creates the final images
fprintf('[%s]:Creating images:',mfilename);
for n = 1:2,
  type       = params.stim(n).type;
  outerRad   = params.stim(n).stimSize;
  innerRad   = 0;
  wedgeWidth = params.stim(1).stimWidth .* (pi/180);
  ringWidth  = outerRad .* params.stim(1).stimWidth ./ 360;
  numImages  = params.stim(n).nFrames ./ params.stim(n).nCycles;
  x          = params.analysis.X;
  y          = params.analysis.Y;
  r          = sqrt (x.^2  + y.^2);
  theta      = atan2 (y, x);	% atan2 returns values between -pi and pi
  theta      = mod(theta,2*pi);	% correct range to be between 0 and 2*pi
  
%  images     = zeros(size(x,2),size(x,1),numImages);
  images     = zeros(prod([size(x,2) size(x,1)]),numImages);
  for imgNum=1:numImages
    img        = zeros(size(x,2),size(x,1));
    switch type;
     case 'wedge',
      loAngle = 2*pi*((imgNum-1)/numImages);
      hiAngle = loAngle + wedgeWidth;
      loEcc   = innerRad;
      hiEcc   = outerRad;
     case 'ring',
      loAngle = 0;
      hiAngle = 2*pi;
      loEcc   = outerRad * (imgNum-1)/numImages;
      hiEcc   = loEcc+ringWidth;
     otherwise,
      error('Unknown stimulus type!');
    end
    window = ( ((theta>=loAngle & theta<hiAngle) | ...
                (hiAngle>2*pi & theta<mod(hiAngle,2*pi))) & ...
               ((r>=loEcc & r<=hiEcc)) & ...
               r<outerRad);
    
    img(window) = 1;
%    images(:,:,imgNum) = img;
    images(:,imgNum) = img(:);
    fprintf('.');drawnow;
  end;
  
  % This operation prepends the stimulus when no fMRI data are saved.
  % The stimulus is used as part of the prediction process, however,
  % because it could influence the response once the data are stored.
%  img                  = repmat(images,[1 1 params.stim(n).nCycles]);
  img                  = repmat(images,[1 params.stim(n).nCycles]);
  onoffIndex           = find(params.stim(n).stimOnOffSeqNoHrf==0);
%  img(:,:,onoffIndex)  = img(:,:,onoffIndex).*0;
  img(:,onoffIndex)    = img(:,onoffIndex).*0;
%  preimg = img(:,:,1+end-params.stim(n).prescanDuration:end);
%  params.stim(n).images = cat(3,preimg,img);
  preimg = img(:,1+end-params.stim(n).prescanDuration:end);
  params.stim(n).images = cat(2,preimg,img);
end;
fprintf('Done.\n');drawnow;
return;

%for n=1:96,figure(1);imagesc(params.stim(2).images(:,:,n),[0 1]);axis off image;colormap gray;pause(.1);end
