function [data, params] = rmLoadData(view,params,slice);
% rmLoadData - load data for retinotopy experiment
%
% data = rmLoadData(view,params);
% 
%
% 2006/01 SOD: wrote it.

if nargin < 2,
  help(mfilename);
  return;
end;

%-----------------------------------
% Place datasets behind each other. This is a rather crude way of
% stimultaneously fitting both. Due to this we cannot
% prewhiten (we could zeropadd/let the trends deal with this/not care). 
% We also, average similar epochs so to save time later.
%-----------------------------------
data = [];
for ds = 1:length(params.stim),
  switch lower(params.wData(1:3)),
    
   case {'all'},
    tmp = loadtSeries(view,ds,slice);
    % convert to percent bold
    tmp = raw2pc(tmp);
    % average repeats
    tmp = rmAverageTime(tmp,params.stim(ds).nUniqueRep);
    
    
   case {'fig'},
    tmp = input(sprintf(['Please select figure with data '...
                        'from scan %d and hit enter.'],ds));
    d   = get(gca,'UserData');
    tmp = d.tSeries;
    
    
   case {'roi'}
    % if no roi is loaded ask and load one
    if view.selectedROI == 0,
      filename = getROIfilename(view);
      view     = loadROI(view,filename);
    end;
    
    % get ROI coords
    coords = view.ROIs(view.selectedROI).coords;
    params.coords = coords;
% getTSeriesROI deals with this
%    if strcmp(view.viewType,'Inplane'),
%      rsFactor = upSampleFactor(view,1);
%      if length(rsFactor)==1
%        coords(1:2,:) = round(coords(1:2,:)/rsFactor(1));
%      else
%        coords(1,:) = round(coords(1,:)/rsFactor(1));
%        coords(2,:) = round(coords(2,:)/rsFactor(2));
%      end;
%      coords = unique(coords','rows')';
%    end;
    if strcmp(lower(view.viewType),'inplane'), 
      roiSlices = unique(coords(3,:));
    else,
      roiSlices = 1;
    end;
    
    tmp = [];
    % loop over slices and load data
    for roiSlice = roiSlices,
      view.tSeriesSlice = roiSlice;
      view.tSeriesScan  = ds;
      view.tSeries = loadtSeries(view,ds,roiSlice);
      
      tmp = [tmp getTSeriesROI(view,coords)];
    end;
    tmp = raw2pc(tmp);
    % average repeats
    tmp = rmAverageTime(tmp,params.stim(ds).nUniqueRep);

    
   otherwise,
    error(sprintf('Unknown parameter wData (%s).',params.wData));
  end;
  
  % append
  data = [data; tmp];
end;

return;
%---------------------------------


%---------------------------------
function data=raw2pc(data),
dc   = ones(size(data,1),1)*mean(data);
data = ((data./dc) - 1) .*100;
return;
%---------------------------------
