function matrixout = rmAverageTime(matrixin,nrep);
% rmAverageTime - average non-unique epochs in time (1st) dimension
%
%  out = rmAverageTime(in,nrep);
%

% 2006/03 SOD: wrote it.

% get total size input
sz  = size(matrixin);

% get total size output
len      = sz(1)./nrep;
szout    = sz; 
szout(1) = len;

% initiate matrixout
matrixout = matrixin(1:len,:);

% repeat (add) process 
start = len;
for n=1:nrep-1,
    matrixout = matrixout + matrixin(start+1:start+len,:);
    start     = start + len;
end;

% mean
matrixout = matrixout ./ nrep;

% reshape if necesary
matrixout = reshape(matrixout,szout);


return