function rfPlot(params,RF);
% rfPlot - script to visualize cropped RF 
%
% rfPlot(params,RF);
%
%

% 2006/02 SOD: wrote it.

mygrid = [-params.analysis.fieldSize:...
          params.analysis.sampleRate:...
          params.analysis.fieldSize];
[x,y]=meshgrid(mygrid,mygrid);
z    = zeros(size(x)).*NaN;
z(params.stim(1).instimwindow) = RF;
z    = reshape(z,size(x));

figure;
surf(x,y,z);
minz = min(z(:));
maxz = max(z(:));
if minz==maxz,
  minz = minz -.1;
  maxz = maxz + .1;
end;
axis([min(x(:)) max(x(:)) min(y(:)) max(y(:)) minz maxz]);
xlabel('x (deg)'); 
ylabel('y (deg)'); 
zlabel('amplitude (% BOLD/deg)'); 
title('RF profile');
