function view=analysisMenu(view)
%
% view=analysisMenu(view)
% 
% Set up the callbacks of the ANALYSIS menu.
% 
% djh, 1/22/98
%
% 7/16/99, djh, added motion compensation, mean map, and resStd map.
% 10/6/99, on,  - activated motion compensation 3D robust.
%               - added plot of residual error between baseFrame
%                 and other frames
% 12/23/99 on, new GUI to motion compensation routines to allow selecting
%               several scans
% 06/06/00 on, - New menu option for BETWEEN SCAN motion compensation
% djh, 2/2010 - use this menu for all viewTypes now that tSeries can be mapped 
%               to the Gray and/or Flat
% ress, 10/05 - Added slice-timing adjustment calculation for Inplane view,
%               and laminar coordinate calculations for volume view.
% $Author: dumoulin $
% $Date: 2006/02/20 17:52:55 $


analysismenu = uimenu('Label','Analysis','Separator','on');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% tSeries submenu

tseriesMenu = uimenu(analysismenu,'Label','Time series','Separator','off');

% Adjust slice timing callback:
callBackstr = ['scans=selectScans(', view.name, ');', ...
    'AdjustSliceTiming(scans);'];
uimenu(tseriesMenu, 'Label', 'Adjust slice timing', 'Separator', 'on', ...
    'CallBack', callBackstr);

% Average tSeries callback:
%   averageTSeries(view);
callBackstr=['averageTSeries(',view.name,');'];
uimenu(tseriesMenu,'Label','Average tSeries','Separator','on',...
    'CallBack',callBackstr);

% Average tSeries Across Sessions callback:
%   averageTSeriesAcrossSessions(view);
callBackstr=['averageTSeriesAcrossSessions;'];
uimenu(tseriesMenu,'Label','Average tSeries across sessions','Separator','on',...
    'CallBack',callBackstr);

% Flip tSeries callback:
%   flipTSeries(view);
callBackstr=['flipTSeries(',view.name,');'];
uimenu(tseriesMenu,'Label','Flip (time-reverse) tSeries','Separator','on',...
    'CallBack',callBackstr);

% Shift tSeries callbacks
%    shiftTSeries(view,shift)
shiftTseriesMenu = uimenu(tseriesMenu,'Label','Shift tSeries','Separator','on');
callBackstr=['shiftTSeries(',view.name,',1);'];
uimenu(shiftTseriesMenu,'Label','Advance 1 frame','Separator','on',...
    'CallBack',callBackstr);
callBackstr=['shiftTSeries(',view.name,',2);'];
uimenu(shiftTseriesMenu,'Label','Advance 2 frames','Separator','on',...
    'CallBack',callBackstr);
callBackstr=['shiftTSeries(',view.name,',3);'];
uimenu(shiftTseriesMenu,'Label','Advance 3 frames','Separator','on',...
    'CallBack',callBackstr);
callBackstr=['shiftTSeries(',view.name,',-1);'];
uimenu(shiftTseriesMenu,'Label','Delay 1 frame','Separator','on',...
    'CallBack',callBackstr);
callBackstr=['shiftTSeries(',view.name,',-2);'];
uimenu(shiftTseriesMenu,'Label','Delay 2 frames','Separator','on',...
    'CallBack',callBackstr);
callBackstr=['shiftTSeries(',view.name,',-3);'];
uimenu(shiftTseriesMenu,'Label','Delay 3 frames','Separator','on',...
    'CallBack',callBackstr);

% Spatially blur tSeries menu:
cb = sprintf('spatialBlurTSeries(%s, ''dialog''); ', view.name);
uimenu(tseriesMenu, 'Label', 'Spatially Blur tSeries',...
        'Separator', 'on', 'Callback', cb);

% Clip frames from beginning/end of tSeries
cb = sprintf('tSeriesClipFrames(%s);',view.name);
uimenu(tseriesMenu,'Label','Clip Frames from tSeries...',...
        'Separator','on','Callback',cb);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% corAnal submenu

coranalMenu = uimenu(analysismenu,'Label','corAnal','Separator','on');

% Correlation analysis (all scans):
%  view = computeCorAnal(view,0);
%  view = refreshScreen(view);
callBackstr=[view.name,'=computeCorAnal(',view.name,',0); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(coranalMenu,'Label','Compute corAnal (all scans)','Separator','on',...
    'CallBack',callBackstr);

% Correlation analysis (current scan):
%  view = computeCorAnal(view,getCurScan(view));
%  view = refreshScreen(view);
callBackstr=[view.name,'=computeCorAnal(',view.name,',getCurScan(',view.name,')); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(coranalMenu,'Label','Compute corAnal (current scan)','Separator','on',...
    'CallBack',callBackstr);

% Correlation analysis (select scans):
%  view = computeCorAnal(view,0);
%  view = refreshScreen(view);
callBackstr=[view.name,'=computeCorAnal(',view.name,'); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(coranalMenu,'Label','Compute corAnal (select scans)','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% meanMap submenu

meanMenu = uimenu(analysismenu,'Label','Mean Map','Separator','on');

% Mean map (all scans):
%   view=computeMeanMap(view,0);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeMeanMap(',view.name,',0); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(meanMenu,'Label','Mean Map (all scans)','Separator','on',...
    'CallBack',callBackstr);

% Mean map (current scan):
%   view=computeMeanMap(view,getCurScan(view));
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeMeanMap(',view.name,',getCurScan(',view.name,')); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(meanMenu,'Label','Mean Map (current scan)','Separator','on',...
    'CallBack',callBackstr);

% Mean map (select scans):
%   view=computeMeanMap(view);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeMeanMap(',view.name,'); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(meanMenu,'Label','Mean Map (select scans)','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% stdMap submenu

stdMenu = uimenu(analysismenu,'Label','Stddev Map','Separator','on');

% Stddev map (all scans):
%   view=computeStdMap(view,0);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeStdMap(',view.name,',0); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(stdMenu,'Label','Stddev Map (all scans)','Separator','on',...
    'CallBack',callBackstr);

% Stddev map (current scan):
%   view=computeResStdMap(view,getCurScan(view));
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeStdMap(',view.name,',getCurScan(',view.name,')); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(stdMenu,'Label','Stddev Map (current scan)','Separator','on',...
    'CallBack',callBackstr);

% Residual Std map (select scans):
%   view=computeStdMap(view);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeStdMap(',view.name,'); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(stdMenu,'Label','Stddev Map (select scans)','Separator','on',...
    'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% resStdMap submenu

resStdMenu = uimenu(analysismenu,'Label','Residual Std Map','Separator','on');

% Residual Std map (all scans):
%   view=computeResStdMap(view,0);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeResStdMap(',view.name,',0); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','Res Std Map (all scans)','Separator','on',...
    'CallBack',callBackstr);

% Residual Std map (current scan):
%   view=computeResStdMap(view,getCurScan(view));
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeResStdMap(',view.name,',getCurScan(',view.name,')); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','Res Std Map (current scan)','Separator','on',...
    'CallBack',callBackstr);

% Residual Std map (select scans):
%   view=computeResStdMap(view);
%   view=setDisplayMode(view,'map');
%   view=refreshScreen(view);
callBackstr=[view.name,'=computeResStdMap(',view.name,'); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','Res Std Map (select scans)','Separator','on',...
    'CallBack',callBackstr);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% -log10Pmap submenu

resStdMenu = uimenu(analysismenu,'Label','-log10 P map','Separator','on');

% log10Pmap (all scans):

callBackstr=[view.name,'=computeProbMap(',view.name,',0); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','-log10 P values (all scans)','Separator','on',...
    'CallBack',callBackstr);

% log10Pmap (current scan):

callBackstr=[view.name,'=computeProbMap(',view.name,',getCurScan(',view.name,')); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','-log10 P values (current scan)','Separator','on',...
    'CallBack',callBackstr);

% log10Pmap (select scans):

callBackstr=[view.name,'=computeProbMap(',view.name,'); ',...
        view.name,'=setDisplayMode(',view.name,',''map''); ',...
        view.name,'=refreshScreen(',view.name,');'];
uimenu(resStdMenu,'Label','-log10 P values (select scans)','Separator','on',...
    'CallBack',callBackstr);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Spatial gradient

if strcmp(view.viewType,'Inplane')
    % Spatial Gradient map callback:
    %   view=computeSpatialGradient(view);
    callBackstr=[view.name,'=computeSpatialGradient(',view.name,');'];
    uimenu(analysismenu,'Label',...
        'Compute Spatial Gradient for Inhomogeneity Correction',...
        'Separator','on','CallBack',callBackstr);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Motion compensation submenu

if strcmp(view.viewType,'Inplane')
    motionMenu = uimenu(analysismenu,'Label','Motion compensation','Separator','on');
    
    % Motion compensation callback:
    %    view = inplaneMotionComp(view)
    callBackstr=[view.name,'=inplaneMotionCompSelScan(',view.name,');'];
    uimenu(motionMenu,'Label','Inplane motion compensation','Separator','on',...
        'CallBack',callBackstr);
    
    % 3d motion compensation callback:
    %    view = motionCompSelScan(view)
    callBackstr=[view.name,'=motionCompSelScan(',view.name,');'];
    uimenu(motionMenu,'Label','3d motion compensation (RECOMMENDED)','Separator','on',...
        'CallBack',callBackstr);
    
    % Between Scans motion compensation
    %    view = betweenScanMotCompSelScan(view)
    callBackstr=[view.name,'=betweenScanMotCompSelScan(',view.name,');'];
    uimenu(motionMenu,'Label','Between Scans Motion Compensation','Separator','on',...
        'CallBack',callBackstr);
    
    % Revert motion compensation callback:
    %    view = revertMotionComp(view)
    callBackstr=[view.name,'=revertMotionCompSelScan(',view.name,');'];
    uimenu(motionMenu,'Label','Revert motion compensation','Separator','on',...
        'CallBack',callBackstr);
    
    % Motion compensation by Mutual Information MI callback:
    %    view = motionCompMutualInfMeanInit(view)
    callBackstr=[view.name,'=motionCompSetArgs(',view.name,');'];
    uimenu(motionMenu,'Label','Motion Compensation (MI)','Separator','on',...
        'CallBack',callBackstr);
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Consecutive frame difference submenu

if strcmp(view.viewType,'Inplane')
    motionMenu = uimenu(analysismenu,'Label','Consecutive frame difference','Separator','on');
    
    % MSE callback:
    %    motionCompPlotMSE(view)
    callBackstr=['motionCompPlotMSE(',view.name,',''selected'');'];
    uimenu(motionMenu,'Label','MSE (current ROI)','Separator','off',...
        'CallBack',callBackstr);
    
    % MI callback:
    %    motionCompPlotMI(view)
    callBackstr=['motionCompPlotMI(',view.name,',''selected'');'];
    uimenu(motionMenu,'Label','MI (current ROI)','Separator','off',...
        'CallBack',callBackstr);
    
    % Compare data types callback:
    %    motionCompCompareDataTypes(view)
    callBackstr=['motionCompCompareDataTypes(',view.name,');'];
    uimenu(motionMenu,'Label','Compare data types','Separator','on',...
        'CallBack',callBackstr);

        
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Frequency Correction Submenu

if strcmp(view.viewType,'Inplane')
    freqCorrectionMenu = uimenu(analysismenu,'Label','Frequency Correction','Separator','on');
    
    % Step1 callback:
    %    reconFreq_step1
    callBackstr=['reconFreqSetArgs_step1(',view.name,');'];
    uimenu(freqCorrectionMenu,'Label','Step 1','Separator','off',...
        'CallBack',callBackstr);     
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Volume/Gray specific analyses

if strcmp(view.viewType,'Volume') | strcmp(view.viewType,'Gray')
    
    volumemenu = uimenu(analysismenu,'Label','Volume view analyses','Separator','on');
    
    % Blur phase in the gray matter callback:
    %   view = blurDialog(view);
    callBackstr=[view.name,'=blurDialog(',view.name,');'];    
    uimenu(volumemenu,'Label','Blur phase','Separator','on',...
        'CallBack',callBackstr);
    
    % Cortical Magnification analysis based on current ROIs
    %   
    % if exist('CORTMAG','var') 
    %  CORTMAG = mrLVolumeCortMag(CORTMAG)
    % else
    % CORTMAG = mrLVolumeCortMag;
    % end    
    callBackstr=['if exist(''CORTMAG'',''var'')',...
            ' CORTMAG = mrLVolumeCortMag(CORTMAG); else CORTMAG = mrLVolumeCortMag; end'];     
    uimenu(volumemenu,'Label','Cortical Magnification','Separator','on',...
        'CallBack',callBackstr);
      
    % Laminar distance calculation
    callBackstr = [view.name, '= ComputeLaminarDistance(', view.name, ');'];
    uimenu(volumemenu, 'Label', 'Laminar distance', 'Separator', 'on', ...
      'CallBack', callBackstr);
    
    % Laminar coordinates calculation
    callBackstr = 'MapLaminarIndices;';
    uimenu(volumemenu, 'Label', 'Laminar coordinates', 'Separator', 'on', ...
      'CallBack', callBackstr);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% retinotopic model submenu

rmMenu = uimenu(analysismenu,'Label','retinotopic model','Separator','on');

% for ROI (for now):
callBackstr=[view.name,'=rmMain(',view.name,',''roi'',[]); ',...
             view.name,'=refreshScreen(',view.name,');'];
uimenu(rmMenu,'Label','roi analysis','Separator','off',...
       'CallBack',callBackstr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
