function  tSeries=doTemporalNormalization(tSeries)
%
% tSeries=doTemporalNormalization(tSeries);
% Author: ARW 
% Date:   032803
% Purpose:
% Performs temporal normalization on a slice by slice basis: 
% Scales each frame so that it has the same mean intensity as the first one

[nFrames,voxelsPerFrame]=size(tSeries);

% Mean of each frame
meanTSerFrames=mean(tSeries,2);

sprintf('Mean tseries value of the first frame %.05f\n',meanTSerFrames(1))

tSeries=(tSeries./repmat(meanTSerFrames,1,voxelsPerFrame))*meanTSerFrames(1);

return;
