function view = computeStdMap(view,scanList)
%
% view = computeStdMap(view,[scanList])
%
% Cycles through tSeries, computing the std of the
% functional images.  Puts them together into a parameter map and
% calls setParameterMap to set view.map = stdMap.
%
% scanList: 
%   0 - do all scans
%   number or list of numbers - do only those scans
%   default - prompt user via selectScans dialog
%
% If you change this function make parallel changes in:
%    computeCorAnal, computeResStdMap, computeMeanMap
%
% djh, 12/30/98
% djh, 2/22/2001 updated to version 3

nScans = numScans(view);

if strcmp(view.mapName,'stdMap')
    % If exists, initialize to existing map
    map=view.map;
else
    % Otherwise, initialize to empty cell array
    map = cell(1,nScans);
end

% (Re-)set scanList
if ~exist('scanList','var')
    scanList = selectScans(view);
elseif scanList == 0
    scanList = 1:nScans;
end
if isempty(scanList)
  error('Analysis aborted');
end

waitHandle = waitbar(0,'Computing std images from the tSeries.  Please wait...');
ncScans = length(scanList);
for iScan = 1:ncScans
    scan = scanList(iScan);
    dims = sliceDims(view,scan);
    slices = sliceList(view,scan);
    nCycles = numCycles(view,scan);
    
    map{scan} = NaN*ones(dataSize(view,scan));
    for slice = slices
        tSeries = loadtSeries(view,scan,slice);
        tmp = std(tSeries);
        map{scan}(:,:,slice) = reshape(tmp,dims);
    end
    waitbar(scan/ncScans)
end
close(waitHandle);

% Set parameter map
view = setParameterMap(view,map,'stdMap');

% Save file
saveParameterMap(view);


