function view = computeSpatialGradient(view)
%
% view = computeSpatialGradient(view)
%
% Loads the meanMap, then uses estFilIntGrad to compute the spatial gradient.
%
% To use this spatial gradient for inhomogeneity correction, 
% - set dataTYPES(*).blockedAnalysis(*).inhomoCorrect = 2
% - load spatial gradient (from the File menu)
% - compute corAnal (from the Analysis menu)
% 
% djh, 7/11/01
% Ress, 04/05 Modified to allow NaNs in meanMap.

% Tried various alternatives for computing spatial gradient:
% - more blurring in estFilIntGrad 
%   [not much difference]
% - aniso3 
%   [looks essentially like no blurring]
% - do nothing
%   [looks a lot like estFilIntGrad, except for a scale factor]

% Load meanMap from spatialGradMap.mat, if it exists
view = loadMeanMap(view);

% Initialize to empty cell array
nScans = numScans(view);
map = cell(1,nScans);

% Compute the robust estimate of spatial gradient from meanMap
waitHandle = waitbar(0,'Computing spatial gradient from mean images.  Please wait...');
for iScan = 1:nScans
  map1 = view.map{iScan};
  map1(~isfinite(map1)) = min(map1(:));
  map{iScan} = estFilIntGrad(map1);
  %map{iScan} = estPolIntGrad(view.map{iScan},[3,3,3],1);
  %map{iScan} = aniso3(view.map{iScan},'tukeyPsi',100,100);
  waitbar(iScan/nScans)
end
close(waitHandle);

% Set parameter map
view = setParameterMap(view,map,'spatialGrad');

% Save file
saveParameterMap(view);

return


% Old code:
% Compute mean volume across all scans
if ~exist('meanVolume','var')
    hiddenInplane = initHiddenInplane;
    % Might want to use selectScans here to give option of choosing a subset of scans.
    nScans = numScans(hiddenInplane);
    scanList = [1:nScans];
    meanVolume = zeros(dataSize(hiddenInplane,1));
    totalNframes = 0;
    waitHandle = waitbar(0,'Computing mean images from the tSeries.  Please wait...');
    for iScan = 1:length(scanList)
        scan = scanList(iScan);
        dims = sliceDims(hiddenInplane,scan);
        totalNframes = totalNframes + numFrames(hiddenInplane,scan);
        for slice = sliceList(hiddenInplane,scan)
            tSeries = loadtSeries(hiddenInplane,scan,slice);
            meanVolume(:,:,slice) = meanVolume(:,:,slice) + reshape(sum(tSeries),dims);
        end
        waitbar(scan/length(scanList))
    end
    close(waitHandle);
    meanVolume = meanVolume / totalNframes;
end
