function view = motionCompSelScan(view, typeName);
%
%  view = motionCompSelScan(view);
%
% Opens a GUI so that the user can select the scans to run the motion
% compensation, and then runs the motion compensation (3D rigid) on the
% scans selected
%
% on, 12/23/99 - original code
% Ress, 5/04 - Now creates a new datatype, and gets smoothing and base
% frame data from user. Produces plots of typical motion detected.

mrGlobals

if isempty(view)
    selectedINPLANE = viewSelected('inplane');
    view = INPLANE{selectedINPLANE};
end
scanList = selectScans(view);

% Prompt user for smoothing and baseFrames:
prompt = {'Smoothing (odd number)', 'Base frame'};
dTitle = 'Motion compensation parameters';
defVal = {'1', ''};
response = inputdlg(prompt, dTitle, 1, defVal);
nSmooth = str2num(response{1});
baseFrame = str2num(response{2});

view = INPLANE{selectedINPLANE};
if ~exist('scans', 'var'), scans = 1:length(dataTYPES(view.curDataType).scanParams); end

% Set up new datatype for motion correction:
hiddenView = initHiddenInplane;
if (~exist('typeName', 'var') | isempty(typeName)), typeName = 'MotionComp'; end
if ~existDataType(typeName), addDataType(typeName); end
hiddenView = selectDataType(hiddenView, existDataType(typeName));
ndataType = hiddenView.curDataType;

% Get the tSeries directory for this dataType 
% (make the directory if it doesn't already exist).
funcDir = tSeriesDir(hiddenView);
nScans = length(scanList);
nx = ceil(sqrt(nScans));
ny = ceil(nScans / nx);
figure;

for iScan=1:nScans
  scan = scanList(iScan);
  % Make the Scan subdirectory for the new tSeries (if it doesn't exist)
  scanDir = fullfile(funcDir, ['Scan',int2str(scan)]);
  if ~exist(scanDir, 'dir')
    mkdir(funcDir, ['Scan',int2str(scan)]);
  end
  motion = motionComp(view, hiddenView, scan, nSmooth, baseFrame);
  subplot(ny, nx, iScan);
  t = 1:size(motion, 2);
  plot(t, motion(1, :), t, motion(2, :), t, sqrt(sum(motion(1:2, :).^2)));
  title(['Motion for scan ', int2str(scan)])
  if iScan==1
    legend('Translation', 'Rotation (typ)', 'Total');
    xlabel('Time (frames)')
    ylabel('Motion (voxels)')
  end
  dataTYPES(ndataType).scanParams(scan) = dataTYPES(view.curDataType).scanParams(scan);
  dataTYPES(ndataType).blockedAnalysisParams(scan) = dataTYPES(view.curDataType).blockedAnalysisParams(scan);
  dataTYPES(ndataType).eventAnalysisParams(scan) = dataTYPES(view.curDataType).eventAnalysisParams(scan);
  dataTYPES(ndataType).scanParams(scan).annotation = dataTYPES(view.curDataType).scanParams(scan).annotation;
end
saveSession

