function view = inplaneMotionComp(view,scan,baseFrame)
%
% view = inplaneMotionComp(view,scan,baseFrame)
%
% Performs inplane motion compensation (by calling inplaneMotionCompSeries)
% on each slice.
%
% scanNum: default current scan
% baseFrame: default 1
%
% If you change this function make parallel changes in:
%   betweenScanMotComp, inplaneMotionComp
%
% djh, 4/16/99

if ~exist('scan','var')
   scanNum = getCurScan(view);
end
if ~exist('baseFrame','var')
   baseFrame=1;
end

slices = sliceList(view,scan);

% make backup copy of tSeries to origTSeries
copyOrigTseries(view,scan);

for slice = slices
   view = inplaneMotionCompSeries(view,scan,slice,baseFrame);
end

