function view = betweenScanMotCompSelScan(view);
%
%  view = motionCompSelScan(view);
%
% Opens a GUI so that the user can select the base scan and the scans
% to run the between scan motion compensation
%
% on, 06/00 - original code
%

baseScan = selectScans(view,'Choose a single base scan');
if isempty(baseScan), return, end
baseScan = baseScan(1);

targetScans = selectScans(view,'Choose scans for motion compensation');
if isempty(targetScans), return, end

% Set up new datatype for motion correction:
hiddenView = initHiddenInplane;
if (~exist('typeName', 'var') | isempty(typeName)), typeName = ['MotionComp_RefScan',int2str(baseScan)]; end
if ~existDataType(typeName), addDataType(typeName); end
hiddenView = selectDataType(hiddenView, existDataType(typeName));

% call the motion compensation routine
[view,M] = betweenScanMotComp(view, hiddenView, baseScan, targetScans);
save(fullfile('Inplane',typeName,'ScanMotionCompParams'),'M','baseScan','targetScans');

% Switch to the new view and compute new mean maps:
ndataType = hiddenView.curDataType;
view = selectDataType(view, ndataType);
saveSession
view = computeMeanMap(view, 0, 1);
view = refreshView(view, 1);
