function [roitSeries, subCoords] = getTseriesOneROI(view, ROIcoords, scanNum, getRawTseries, removeRedundant)
% 
%   [roitSeries, subCoords] = getTseriesOneROI(view,ROIcoords,scanNum, getRawTseriesFlag(=0 default), removeRedundantFlag(=1 default) )
%
% For a single ROI, we loop through slices and acquire all of the
% tSeries(voxel by voxel). Return these time courses, removing redundant
% tSeries (which occur because several anatomical coords may reference the
% same functional voxel). Also returns the locations of the non-redundant
% voxels in subCoords.
% The removing redundant can be turned off by removeRedundantFlag = 0;
%
% ras, 04/04: remove redundant time courses from upsampling the functional.
% ras, 05/04: also, return the sub-coords, with the redundant voxels
% removed. (They'll be in the coordinates of the inplane anatomy, but 
% there will only be one voxel contained within a given functional voxel.)
% ras, 5/2004 -- now it returns the tSeries in the order that corresponds
% to the voxels specified in ROIcoords (before, it would return in them
% in a semi-shuffled order if you were in the inplane view -- b/c of 
% the loop through slices).
% jl, 5/2005 - make "remove redundant from upsampling" optional

% Make sure the input is in the right format
if (~exist('ROIcoords','var') | isempty(ROIcoords)), ROIcoords = getCurROIcoords(view); end
if (~exist('scanNum','var') | isempty(scanNum)), scanNum = getCurScan(view); end
if (~exist('getRawTseries','var')  | isempty(getRawTseries)),  getRawTseries = 0; end
if (~exist('removeRedundant','var')  | isempty(removeRedundant)),  removeRedundant = 1; end

ROIcoords = ROIcoords2cellArray(view,ROIcoords);

% b/c of upsampling b/w the functionals and anats,
% there tend to be redundant coords specifying the 
% same functional voxel -- remove these:
switch view.viewType
    case 'Inplane',
        if removeRedundant
            % b/c of upsampling b/w the functionals and anats, there tend to be redundant coords
            % specifying the same functional voxel -- remove these:
            subCoords = roiSubCoords(view,ROIcoords{1},scanNum);
        end
        ROIcoords = {subCoords};
    case 'Flat',
        % the tSeries will only cover points
        % on the flat map mapped by the ROI, 
        % ignoring ones on blank/masked nodes
        ind = sub2ind(size(view.indices),ROIcoords{1}(1,:),...
                        ROIcoords{1}(2,:),ROIcoords{1}(3,:));
        ind = find(view.indices(ind)>0);
        subCoords = ROIcoords{1}(:,ind);
    otherwise,
        subCoords = ROIcoords;
end

% Find the slice indices for this collection of ROIs
sliceInds = getSlicesROI(view,ROIcoords);

roitSeries = [];

nFrames = numFrames(view,scanNum);
detrend = detrendFlag(view,scanNum);
smoothFrames = detrendFrames(view,scanNum);

% Find the slice indices for this collection of ROIs
sliceInds = getSlicesROI(view,ROIcoords);

for iSlice = 1:length(sliceInds)
    slice = sliceInds(iSlice);
    
    % Load tSeries & divide by mean, but don't detrend yet.
    % Otherwise, detrending the entire tSeries is much slower. DJH
    % this crashes on the volume - out of memory - kgs 06/05
    % rewrote this section
    if(getRawTseries)
        view = percentTSeries(view,scanNum,slice,0,0,0,1);
     else
        view = percentTSeries(view,scanNum,slice,0);
     end
 
    % Extract time-series from the current slice
    subtSeries = getTSeriesROI(view,ROIcoords{1});
    
    if ~isempty(subtSeries) & ~getRawTseries
        % Norm and Detrend (faster and doesn't crash after extracting subtSeries for a small subset of the voxels)
        subtSeries = detrendTSeries(subtSeries,detrend,smoothFrames);
    end
    
    switch view.viewType
        case 'Inplane',
            % assign to the columns in roitSeries that correspond to the selected
            % voxels:
            voxelsInSlice = find(ROIcoords{1}(3,:) == view.tSeriesSlice);    
            roitSeries(:,voxelsInSlice) = subtSeries;
        case 'Gray',
            roitSeries = subtSeries;
        case 'Volume',
            roitSeries = subtSeries;
        case 'Flat',
            roitSeries = [roitSeries subtSeries];
    end
end

% make a cell (to be in line with multi-ROI analyses)
roitSeries = {roitSeries};
clear view.tSeries; % free memory


return
