function [subtSeries, subIndices]= getTSeriesROI(view,ROIcoords)
% getTSeriesROI - Extract subtSeries from view.tSeries for given ROI.
%
%  [subtSeries, subIndices] = getTSeriesROI(view,ROIcoords)
%
% This only returns the tSeries values from the currently loaded slice and
% scan.  Perhaps it should mention that fact in its name?  Or maybe it
% should go through all the slices.  Probably we should put this
% functionality into viewGet() and have it work for all slices.
%
% subIndices: indices of those columns
% within the relevant tSeries matrix which correspond
% to the returned subtSeries.
%
%
% djh, 2/2001
% ras, 1/2004
% - fixed a bug for the case where the upSampleFactor is different in
% different directions.
% ras, 10/2004
% - commented out the part where it errors
% if a tSeries spans slices / hemis. Why not?
% (plus, it's crucial for an acr-levels analysis)
% ras, 04/05
% - returns coordinates from which each voxel was taken
% sod 01/2006: modification to use only unique coordinates
%

if isempty(ROIcoords) | isempty(view.tSeries)
    subtSeries = [];
else
    switch view.viewType
        case 'Inplane'
            scan = view.tSeriesScan;
            
            % Need to divide the ROIcoords by the upSample factor because the
            % data are no longer interpolated to the inplane size.
            rsFactor = upSampleFactor(view,scan);

            if length(rsFactor)==1
                ROIcoords(1:2,:) = round(ROIcoords(1:2,:)/rsFactor(1));
            else
                ROIcoords(1,:) = round(ROIcoords(1,:)/rsFactor(1));
                ROIcoords(2,:) = round(ROIcoords(2,:)/rsFactor(2));
            end
            % no need to keep duplicate coords
            ROIcoords = unique(ROIcoords','rows')';
            
            inSlice = find(ROIcoords(3,:) == view.tSeriesSlice);
            subIndices = coords2Indices(ROIcoords(1:2,inSlice),sliceDims(view,scan));

            % pull out the tSeries for included pixels
            subtSeries = view.tSeries(:,subIndices);

        case {'Gray' 'Volume'}

            [inter,ROIIndices,subIndices] = intersectCols(ROIcoords,view.coords);

            subtSeries = view.tSeries(:,subIndices);

        case 'Flat'

            % choose sub-ROIcoords from the currently loaded slice
            subInd = find(ROIcoords(3,:)==view.tSeriesSlice);
            subCoords = ROIcoords(:,subInd);

            ind = sub2ind(size(view.indices),subCoords(1,:),subCoords(2,:),subCoords(3,:));
            subIndices = view.indices(ind);
            subIndices = subIndices(subIndices>0); % ignore non-measured points

            % this assumes the view's tSeries will only
            % be for the current slice -- if the way tSeries
            % are processed is updated (in percentTSeries, loadtSeries,
            % etc), make sure to update this:
            subtSeries = view.tSeries(:,subIndices);
    end
end

return


% % Older:
%         h=view.tSeriesSlice;
%         if find(h ~= ROIcoords(3,:))
%             myErrorDlg('getTSeriesROI: ROIcoords must all be from the same hemisphere.');
%         end
