function clusterList = clustersFindActivated(vw,whichMap,thresh)
%
%
%   clusterList = clustersFindActivated(nodes,edges,pMap)
%
% nodes and edges are the gray matter connectivity mesh
%
% pMap:  Is a set of locations identified with the node positions
%
% clusterList is a cell array of the nodes that form the different
% clusters.
%
%
% Examples:
%   clusterList = clustersFindActivated(VOLUME{1},'statisticalMap',6)
%    

if ieNotDefined('vw'), error('Must send in a view'); end
if ieNotDefined('whichMap'), whichMap = 'co'; end
if ieNotDefined('thresh')
    % Go read the sliders
end

data = viewGet(vw,'mapn',viewGet(vw,'currentScan'));
nodes = viewGet(vw,'nodes');
edges = viewGet(vw,'edges');
%   nReached = checkGrayContinuity(nodes,edges,dimdist)

% thresh = 0.01
activeNodes = find(data > thresh);

foundList = zeros(size(activeNodes));
whichNode = activeNodes(1);
foundList(whichNode) = 1;
lNumber = 1;
while ~isempty(whichNode)
  connectedActiveNodes{lNumber} = connectedCluster(nodes,edges,activeNodes,whichNode)
  foundList(connectedActiveNodes{lNumber}) = lNumber;
  whichNode = min(find(foundList == 0));
  lNumber = lNumber + 1;
end

return;

%---------------------------------
function connectedNodes = findConnectedPoints(whichNode,nodes,edges)

edgeNeighbors  = nodes(4,whichNode)
edgeOffset     = nodes(5,whichNode)
connectedNodes = edges( (edgeOffset-1) + [1:edgeNeighbors])

return

%------------------------------
function listOfConnectedActiveNodes = connectedCluster(nodes,edges,activeNodes,whichNode)

while ~isempty(find(foundList == 0))

    connectedNodes       = findConnectedPoints(whichNode,nodes,edges)
    connectedActiveNodes = find(ismember(connectedNodes,activeNodes))

    if isempty(connectedActiveNodes)

    else

        % Mark the list entries
        foundList(connectedActiveNodes) = whichList;
    end
end

return;
