function [meanAmps,meanPhs,seAmps,SEM] = vectorMeans(view)
%
% [meanAmps,meanPhs,seAmps] = vectorMeans(view)
% 
% Calculates mean amplitudes and phases for all scans, for pixels
% that are in the currently selected ROI.
%
% djh 4/24/98
% bw  2/19/99 Added seAmps as a temporary measure for returning
% error bars on the plot.
nscans = numScans(view);

% Get selpts from current ROI
ROIcoords = getCurROIcoords(view);

% Compute vector mean for each scan
meanAmps = zeros(1,nscans);
meanPhs = zeros(1,nscans);
seAmps = zeros(1,nscans);
SEM=zeros(1,nscans);

for scanNum = 1:nscans
    
  [meanAmp,meanPh,seZ,meanStd] = vectorMean(view,scanNum,ROIcoords);
  meanAmps(scanNum) = meanAmp;
  meanPhs(scanNum) = meanPh;
  seAmps(scanNum) = seZ;
  meanStds(scanNum)=meanStd;
  SEM(scanNum)=meanStd/numCycles(view,scanNum);
end

