function view = computeResStdMap(view, scanList)
%
% view = computeResStdMap(view, [scanList])
%
% Cycles through tSeries, computing the residual std of the
% functional images.  Puts them together into a parameter map and
% calls setParameterMap to set view.map = stdMap.
% Residual time series have the harmonics of freq removed
%
% scanList: 
%   0 - do all scans
%   number or list of numbers - do only those scans
%   default - prompt user via selectScans dialog
%
% If you change this function make parallel changes in:
%    computeCorAnal, computeStdMap, computeMeanMap
%
% rmk, 05/05/99
% djh 2/2001, mrLoadRet-3.0
    
nScans = numScans(view);

if strcmp(view.mapName,'resStdMap')
    % If exists, initialize to existing map
    map=view.map;
else
    % Otherwise, initialize empty cell array
    map = cell(1,nScans);
end

% (Re-)set scanList
if ~exist('scanList','var')
    scanList = selectScans(view);
elseif scanList == 0
    scanList = 1:nScans;
end
if isempty(scanList)
  error('Analysis aborted');
end

% Compute it
waitHandle = waitbar(0,'Computing res std images from the tSeries.  Please wait...');
ncScans = length(scanList);
for iScan = 1:ncScans
    scan = scanList(iScan);
    dims = sliceDims(view,scan);
    nCycles = numCycles(view,scan);
    
    map{scan} = NaN*ones(dataSize(view,scan));
    for slice = sliceList(view,scan)
        resStd = computeTSResStd(view,scan,slice,nCycles);
        map{scan}(:,:,slice) = reshape(resStd,dims);
    end
    waitbar(scan/ncScans)
end
close(waitHandle);

% Set parameter map
view = setParameterMap(view,map,'resStdMap');

% Save file
saveParameterMap(view);


