function retPhases = atlasEstimatePhases(view,areaCorners,scanNum)
%
%   retPhases = atlasEstimatePhases(view,areaCorners,scanNum)
%
% scanNum is the scan number of the wedge and ring in this view
%

nAreas = length(areaCorners);
for ii=1:nAreas
    corners = areaCorners{ii};
    retPhases(ii,1) = atlasEstimateBoundaryPhases(view,corners(1,:),corners(2,:),scanNum(1));
    retPhases(ii,2) = atlasEstimateBoundaryPhases(view,corners(3,:),corners(4,:),scanNum(1));
    retPhases(ii,3) = atlasEstimateBoundaryPhases(view,corners(1,:),corners(4,:),scanNum(2));
    retPhases(ii,4) = atlasEstimateBoundaryPhases(view,corners(2,:),corners(3,:),scanNum(2));
end

if nAreas > 1, retPhases = meanPhase(retPhases); end

prompt={'Foveal','Peripheral','Lower Phase (angle map)'};
def={num2str(retPhases(1)),num2str(retPhases(2)),num2str(retPhases(3))};
dlgTitle='Adjust retinal phase estimates';
lineNo=1;
answer=inputdlg(prompt,dlgTitle,lineNo,def);

angleShift = retPhases(3) - str2num(answer{3});
for ii=1:3, retPhases(ii) = str2num(answer{ii}); end 
retPhases(4) = retPhases(4) - angleShift;

return;

%----------------------------------------------------
function meanPh = atlasEstimateBoundaryPhases(view,p1,p2,scanNum)
%
%   meanPh = atlasEstimateBoundaryPhases(view,p1,p2,scanNum)
%
% Author:  Wandell
% Purpose:
%     Estimate the average phase along a line between two points.  This
%     code is used to provide first estimates of the foveal, peripheral,
%     UVM and LVM phase in building atlases.
%
% Example:
%
%   scanNum = 1
%   retPhase(1) = atlasEstimateBoundaryPhases(view,corners(1,:),corners(2,:),scanNum);


curSlice = getCurSlice(view);
[x, y] = findLinePoints([p1(1) p1(2)], [p2(1) p2(2)]);

newCoords = zeros(3,length(x));
newCoords(1,:) = y;
newCoords(2,:) = x;
newCoords(3,:) = curSlice*ones(1,length(x));

% Convert coords to canonical frame of reference
newCoords = curOri2CanOri(view,newCoords);
ph = getCurDataROI(view,'ph',scanNum,newCoords);
cxph = exp(sqrt(-1)*ph);

% We add pi to the output so that the variables run from [0,2pi] instead of
% from [-pi,pi].  This is consistent with mrLoadRet encoding of phase.
meanPh = angle(mean(cxph));

if meanPh < 0, meanPh = meanPh + 2*pi; end
if meanPh > 2*pi, meanPh = meanPh - 2*pi; end

return;
